/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy.dsl.configuration.endpoints;

import org.citrusframework.Citrus;
import org.citrusframework.CitrusContext;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.groovy.dsl.GroovyShellUtils;
import org.citrusframework.groovy.dsl.configuration.endpoints.EndpointsConfiguration;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class EndpointConfigurationScript
implements ReferenceResolverAware {
    private ReferenceResolver referenceResolver;
    private final String script;

    public EndpointConfigurationScript(String script, Citrus citrus) {
        this(script, citrus.getCitrusContext());
    }

    public EndpointConfigurationScript(String script, CitrusContext citrusContext) {
        this(script, citrusContext.getReferenceResolver());
    }

    public EndpointConfigurationScript(String script, ReferenceResolver referenceResolver) {
        this.script = script;
        this.referenceResolver = referenceResolver;
    }

    public EndpointConfigurationScript(String script) {
        this.script = script;
    }

    public void execute(TestContext context) {
        EndpointsConfiguration configuration = new EndpointsConfiguration();
        ImportCustomizer ic = new ImportCustomizer();
        GroovyShellUtils.run(ic, (Object)configuration, context.replaceDynamicContentInString(this.script), null, context);
        configuration.getEndpoints().forEach(endpoint -> {
            this.onCreate((Endpoint)endpoint);
            if (endpoint instanceof InitializingPhase) {
                ((InitializingPhase)endpoint).initialize();
            }
            if (this.referenceResolver != null) {
                this.referenceResolver.bind(endpoint.getName(), endpoint);
            } else {
                context.getReferenceResolver().bind(endpoint.getName(), endpoint);
            }
        });
    }

    protected void onCreate(Endpoint endpoint) {
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }
}

