/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.groovy.dsl.configuration.endpoints;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObjectSupport;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.groovy.dsl.configuration.endpoints.EndpointBuilderWrapper;
import org.citrusframework.groovy.dsl.configuration.endpoints.EndpointConfiguration;

public class EndpointsConfiguration
extends GroovyObjectSupport {
    private final Set<Supplier<Endpoint>> endpoints = new HashSet<Supplier<Endpoint>>();

    public void endpoints(@DelegatesTo(value=EndpointsConfiguration.class) Closure<?> callable) {
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)this);
        callable.call();
    }

    public Endpoint endpoint(String type, Closure<?> callable) {
        EndpointConfiguration endpointSupplier = new EndpointConfiguration(type);
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)endpointSupplier);
        callable.call();
        this.endpoints.add(endpointSupplier);
        return (Endpoint)endpointSupplier.get();
    }

    public Endpoint endpoint(String type, String endpointName, Closure<?> callable) {
        EndpointConfiguration endpointSupplier = new EndpointConfiguration(type);
        callable.setResolveStrategy(1);
        callable.setDelegate((Object)endpointSupplier);
        callable.call();
        this.endpoints.add(endpointSupplier);
        Endpoint endpoint = (Endpoint)endpointSupplier.get();
        endpoint.setName(endpointName);
        return endpoint;
    }

    public Object methodMissing(String name, Object argLine) {
        Object[] args = Optional.ofNullable(argLine).map(Object[].class::cast).orElseGet(() -> new Object[0]);
        if (args.length > 1) {
            String endpointName = args[0].toString();
            Object closure = args[1];
            if (closure instanceof Closure) {
                return this.endpoint(name, endpointName, (Closure)closure);
            }
            EndpointBuilderWrapper wrapper = new EndpointBuilderWrapper(name, endpointName);
            this.endpoints.add(wrapper);
            return wrapper;
        }
        if (args.length == 1) {
            Object closureOrName = args[0];
            if (closureOrName instanceof Closure) {
                return this.endpoint(name, (Closure)closureOrName);
            }
            EndpointBuilderWrapper wrapper = new EndpointBuilderWrapper(name, closureOrName.toString());
            this.endpoints.add(wrapper);
            return wrapper;
        }
        EndpointBuilderWrapper wrapper = new EndpointBuilderWrapper(name, name);
        this.endpoints.add(wrapper);
        return wrapper;
    }

    public Set<Endpoint> getEndpoints() {
        return this.endpoints.stream().map(Supplier::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

