/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.script;

import java.io.IOException;
import java.nio.charset.Charset;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.groovy.dsl.GroovyShellUtils;
import org.citrusframework.groovy.dsl.configuration.beans.BeansConfiguration;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;

public class CreateBeansAction
extends AbstractTestAction {
    private final String script;
    private final String scriptResourcePath;

    public CreateBeansAction(Builder builder) {
        super("groovy-beans", (AbstractTestActionBuilder)builder);
        this.script = builder.script;
        this.scriptResourcePath = builder.scriptResourcePath;
    }

    public void doExecute(TestContext context) {
        try {
            if (!StringUtils.hasText((String)this.script) && this.scriptResourcePath == null) {
                throw new CitrusRuntimeException("Neither inline script nor external script resource is defined. Unable to execute groovy script.");
            }
            String resolvedScript = StringUtils.hasText((String)this.script) ? this.script.trim() : FileUtils.readToString((Resource)FileUtils.getFileResource((String)this.scriptResourcePath, (TestContext)context));
            resolvedScript = context.replaceDynamicContentInString(resolvedScript.trim());
            GroovyShellUtils.run((Object)new BeansConfiguration(context.getReferenceResolver()), resolvedScript, null, context);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to load bean configuration script", (Throwable)e);
        }
    }

    public String getScript() {
        return this.script;
    }

    public String getScriptResourcePath() {
        return this.scriptResourcePath;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<CreateBeansAction, Builder> {
        private String script;
        private String scriptResourcePath;

        public Builder script(String script) {
            this.script = script;
            return this;
        }

        public Builder script(Resource scriptResource) {
            return this.script(scriptResource, FileUtils.getDefaultCharset());
        }

        public Builder script(Resource scriptResource, Charset charset) {
            try {
                this.script = FileUtils.readToString((Resource)scriptResource, (Charset)charset);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read script resource file", (Throwable)e);
            }
            return this;
        }

        public Builder scriptResourcePath(String scriptResourcePath) {
            this.scriptResourcePath = scriptResourcePath;
            return this;
        }

        public CreateBeansAction build() {
            return new CreateBeansAction(this);
        }
    }
}

