/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.controller;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.endpoint.adapter.EmptyResponseEndpointAdapter;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.client.HttpEndpointConfiguration;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.server.HttpServerSettings;
import org.citrusframework.message.Message;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UrlPathHelper;

@Controller
@RequestMapping(value={"/*"})
public class HttpMessageController {
    private EndpointAdapter endpointAdapter = new EmptyResponseEndpointAdapter();
    private HttpEndpointConfiguration endpointConfiguration = new HttpEndpointConfiguration();
    private final ConcurrentHashMap<HttpServletRequest, ResponseEntity<?>> responseCache = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<HttpServletRequest> activeRequests = new ConcurrentLinkedQueue();
    private int responseCacheSize = HttpServerSettings.responseCacheSize();

    @RequestMapping(value={"**"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> handleGetRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.GET, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> handlePostRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.POST, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> handlePutRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.PUT, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> handleDeleteRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.DELETE, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.OPTIONS})
    @ResponseBody
    public ResponseEntity<?> handleOptionsRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.OPTIONS, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.HEAD})
    @ResponseBody
    public ResponseEntity<?> handleHeadRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.HEAD, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.TRACE})
    @ResponseBody
    public ResponseEntity<?> handleTraceRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.TRACE, requestEntity);
    }

    @RequestMapping(value={"**"}, method={RequestMethod.PATCH})
    @ResponseBody
    public ResponseEntity<?> handlePatchRequest(HttpEntity<Object> requestEntity) {
        return this.handleRequestInternal(HttpMethod.PATCH, requestEntity);
    }

    private ResponseEntity<?> handleRequestInternal(HttpMethod method, HttpEntity<?> requestEntity) {
        ResponseEntity responseEntity;
        HttpMessage request = this.endpointConfiguration.getMessageConverter().convertInbound(requestEntity, this.endpointConfiguration, null);
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        if (attributes == null) {
            throw new CitrusRuntimeException("Failed to retrieve servlet request");
        }
        HttpServletRequest servletRequest = ((ServletRequestAttributes)attributes).getRequest();
        UrlPathHelper pathHelper = new UrlPathHelper();
        Enumeration allHeaders = servletRequest.getHeaderNames();
        for (String headerName : (String[])CollectionUtils.toArray((Enumeration)allHeaders, (Object[])new String[0])) {
            if (request.getHeader(headerName) != null) continue;
            String headerValue = servletRequest.getHeader(headerName);
            request.header(headerName, headerValue != null ? headerValue : "");
        }
        if (this.endpointConfiguration.isHandleCookies()) {
            request.setCookies(servletRequest.getCookies());
        }
        if (this.endpointConfiguration.isHandleAttributeHeaders()) {
            Enumeration attributeNames = servletRequest.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                Object attribute = servletRequest.getAttribute(attributeName);
                request.setHeader(attributeName, attribute);
            }
        }
        request.path(pathHelper.getRequestUri(servletRequest)).uri(pathHelper.getRequestUri(servletRequest)).contextPath(pathHelper.getContextPath(servletRequest)).queryParams(Optional.ofNullable(pathHelper.getOriginatingQueryString(servletRequest)).map(queryString -> queryString.replaceAll("&", ",")).orElse("")).version(servletRequest.getProtocol()).method(method);
        Message response = this.endpointAdapter.handleMessage((Message)request);
        if (response == null) {
            responseEntity = new ResponseEntity((HttpStatusCode)HttpStatus.valueOf((int)this.endpointConfiguration.getDefaultStatusCode()));
        } else {
            HttpMessage httpResponse = response instanceof HttpMessage ? (HttpMessage)response : new HttpMessage(response);
            if (httpResponse.getStatusCode() == null) {
                httpResponse.status(HttpStatus.valueOf((int)this.endpointConfiguration.getDefaultStatusCode()));
            }
            responseEntity = (ResponseEntity)this.endpointConfiguration.getMessageConverter().convertOutbound((Message)httpResponse, this.endpointConfiguration, null);
            if (this.endpointConfiguration.isHandleCookies() && httpResponse.getCookies() != null) {
                HttpServletResponse servletResponse = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
                if (servletResponse == null) {
                    throw new CitrusRuntimeException("Failed to retrieve servlet response");
                }
                for (Cookie cookie : httpResponse.getCookies()) {
                    servletResponse.addCookie(cookie);
                }
            }
        }
        this.responseCache.put(servletRequest, responseEntity);
        this.activeRequests.add(servletRequest);
        this.clearResponseCacheEntries(this.activeRequests, this.responseCache);
        return responseEntity;
    }

    private void clearResponseCacheEntries(ConcurrentLinkedQueue<HttpServletRequest> activeRequests, ConcurrentHashMap<HttpServletRequest, ResponseEntity<?>> responseCache) {
        while (activeRequests.size() >= this.responseCacheSize) {
            Optional.ofNullable(activeRequests.poll()).ifPresent(responseCache::remove);
        }
    }

    public void setEndpointAdapter(EndpointAdapter endpointAdapter) {
        this.endpointAdapter = endpointAdapter;
    }

    public EndpointAdapter getEndpointAdapter() {
        return this.endpointAdapter;
    }

    public HttpEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public void setEndpointConfiguration(HttpEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    public ResponseEntity<?> getResponseCache(HttpServletRequest request) {
        return this.responseCache.get(request);
    }

    public int getResponseCacheSize() {
        return this.responseCacheSize;
    }

    public void setResponseCacheSize(int responseCacheSize) {
        this.responseCacheSize = responseCacheSize;
    }
}

