/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.message;

import jakarta.servlet.http.Cookie;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.message.CookieConverter;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class HttpMessage
extends DefaultMessage {
    private final Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private final transient Map<String, Collection<String>> queryParams = new HashMap<String, Collection<String>>();
    private final CookieConverter cookieConverter = new CookieConverter();

    public HttpMessage() {
    }

    public HttpMessage(Message message) {
        super(message);
        this.copyCookies(message);
    }

    public HttpMessage(Object payload) {
        super(payload);
    }

    public HttpMessage(Object payload, Map<String, Object> headers) {
        super(payload, headers);
    }

    private void copyCookies(Message message) {
        if (message instanceof HttpMessage) {
            this.cookies.putAll(((HttpMessage)message).getCookiesMap());
        }
    }

    public HttpMessage method(HttpMethod method) {
        this.setHeader("citrus_http_method", method.name());
        return this;
    }

    public HttpMessage version(String version) {
        this.setHeader("citrus_http_version", version);
        return this;
    }

    public HttpMessage status(HttpStatus statusCode) {
        this.statusCode(statusCode.value());
        this.reasonPhrase(statusCode.name());
        return this;
    }

    public HttpMessage statusCode(Integer statusCode) {
        this.setHeader("citrus_http_status_code", statusCode);
        return this;
    }

    public HttpMessage reasonPhrase(String reasonPhrase) {
        this.setHeader("citrus_http_reason_phrase", reasonPhrase);
        return this;
    }

    public HttpMessage uri(String requestUri) {
        this.setHeader("citrus_endpoint_uri", requestUri);
        this.setHeader("citrus_http_request_uri", requestUri);
        return this;
    }

    public HttpMessage contentType(String contentType) {
        this.setHeader("Content-Type", contentType);
        return this;
    }

    public HttpMessage accept(String accept) {
        this.setHeader("Accept", accept);
        return this;
    }

    public HttpMessage contextPath(String contextPath) {
        this.setHeader("citrus_http_context_path", contextPath);
        return this;
    }

    public HttpMessage queryParams(String queryParamString) {
        this.header("citrus_http_query_params", queryParamString);
        this.header("citrus_query_params", queryParamString);
        Stream.of(queryParamString.split(",")).map(keyValue -> Optional.ofNullable(StringUtils.split((String)keyValue, (String)"=")).orElse(new String[]{keyValue, ""})).filter(keyValue -> StringUtils.hasText((String)keyValue[0])).forEach(keyValue -> this.addQueryParam(keyValue[0], keyValue[1]));
        return this;
    }

    public HttpMessage queryParam(String name) {
        return this.queryParam(name, null);
    }

    public HttpMessage queryParam(String name, String value) {
        if (!StringUtils.hasText((String)name)) {
            throw new CitrusRuntimeException("Invalid query param name - must not be empty!");
        }
        this.addQueryParam(name, value);
        String queryParamString = this.queryParams.entrySet().stream().map(this::outputQueryParam).collect(Collectors.joining(","));
        this.header("citrus_http_query_params", queryParamString);
        this.header("citrus_query_params", queryParamString);
        return this;
    }

    public HttpMessage path(String path) {
        this.header("citrus_http_request_uri", path);
        this.header("citrus_request_path", path);
        return this;
    }

    public HttpMessage header(String headerName, Object headerValue) {
        return (HttpMessage)super.setHeader(headerName, headerValue);
    }

    public HttpMessage setHeader(String headerName, Object headerValue) {
        return (HttpMessage)super.setHeader(headerName, headerValue);
    }

    public HttpMessage addHeaderData(String headerData) {
        return (HttpMessage)super.addHeaderData(headerData);
    }

    public RequestMethod getRequestMethod() {
        Object method = this.getHeader("citrus_http_method");
        if (method != null) {
            return RequestMethod.valueOf((String)method.toString());
        }
        return null;
    }

    public String getUri() {
        Object requestUri = this.getHeader("citrus_http_request_uri");
        if (requestUri != null) {
            return requestUri.toString();
        }
        return null;
    }

    public String getContextPath() {
        Object contextPath = this.getHeader("citrus_http_context_path");
        if (contextPath != null) {
            return contextPath.toString();
        }
        return null;
    }

    public String getContentType() {
        Object contentType = this.getHeader("Content-Type");
        if (contentType != null) {
            return contentType.toString();
        }
        return null;
    }

    public String getAccept() {
        Object accept = this.getHeader("Accept");
        if (accept != null) {
            return accept.toString();
        }
        return null;
    }

    public Map<String, Collection<String>> getQueryParams() {
        return this.queryParams;
    }

    public String getQueryParamString() {
        return Optional.ofNullable(this.getHeader("citrus_http_query_params")).map(Object::toString).orElse("");
    }

    public HttpStatus getStatusCode() {
        Object statusCode = this.getHeader("citrus_http_status_code");
        if (statusCode != null) {
            if (statusCode instanceof HttpStatus) {
                return (HttpStatus)statusCode;
            }
            if (statusCode instanceof Integer) {
                return HttpStatus.valueOf((int)((Integer)statusCode));
            }
            return HttpStatus.valueOf((int)Integer.valueOf(statusCode.toString()));
        }
        return null;
    }

    public String getReasonPhrase() {
        Object reasonPhrase = this.getHeader("citrus_http_reason_phrase");
        if (reasonPhrase != null) {
            return reasonPhrase.toString();
        }
        return null;
    }

    public String getVersion() {
        Object version = this.getHeader("citrus_http_version");
        if (version != null) {
            return version.toString();
        }
        return null;
    }

    public String getPath() {
        Object path = this.getHeader("citrus_request_path");
        if (path != null) {
            return path.toString();
        }
        return null;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    private Map<String, Cookie> getCookiesMap() {
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies.clear();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                this.cookie(cookie);
            }
        }
    }

    public HttpMessage cookie(Cookie cookie) {
        this.cookies.put(cookie.getName(), cookie);
        this.setHeader("citrus_http_cookie_" + cookie.getName(), this.cookieConverter.getCookieString(cookie));
        return this;
    }

    public static HttpMessage fromRequestData(String requestData) {
        HttpMessage httpMessage;
        BufferedReader reader = new BufferedReader(new StringReader(requestData));
        try {
            HttpMessage request = new HttpMessage();
            String[] requestLine = reader.readLine().split("\\s");
            if (requestLine.length > 0) {
                request.method(HttpMethod.valueOf((String)requestLine[0]));
            }
            if (requestLine.length > 1) {
                request.uri(requestLine[1]);
            }
            if (requestLine.length > 2) {
                request.version(requestLine[2]);
            }
            httpMessage = HttpMessage.parseHttpMessage(reader, request);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to parse Http raw request data", (Throwable)e);
            }
        }
        reader.close();
        return httpMessage;
    }

    public static HttpMessage fromResponseData(String responseData) {
        HttpMessage httpMessage;
        BufferedReader reader = new BufferedReader(new StringReader(responseData));
        try {
            HttpMessage response = new HttpMessage();
            String[] statusLine = reader.readLine().split("\\s");
            if (statusLine.length > 0) {
                response.version(statusLine[0]);
            }
            if (statusLine.length > 1) {
                response.status(HttpStatus.valueOf((int)Integer.valueOf(statusLine[1])));
            }
            httpMessage = HttpMessage.parseHttpMessage(reader, response);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to parse Http raw response data", (Throwable)e);
            }
        }
        reader.close();
        return httpMessage;
    }

    private void addQueryParam(String name, String value) {
        if (!this.queryParams.containsKey(name)) {
            this.queryParams.put(name, new LinkedList());
        }
        this.queryParams.get(name).add(value);
    }

    private String outputQueryParam(Map.Entry<String, Collection<String>> entry) {
        return entry.getValue().stream().map(entryValue -> (String)entry.getKey() + (String)(entryValue != null ? "=" + entryValue : "")).collect(Collectors.joining(","));
    }

    private static HttpMessage parseHttpMessage(BufferedReader reader, HttpMessage message) throws IOException {
        String line = reader.readLine();
        while (StringUtils.hasText((String)line)) {
            if (!line.contains(":")) {
                throw new CitrusRuntimeException(String.format("Invalid header syntax in line - expected 'key:value' but was '%s'", line));
            }
            String[] keyValue = line.split(":");
            message.setHeader(keyValue[0].trim(), keyValue[1].trim());
            line = reader.readLine();
        }
        StringBuilder bodyBuilder = new StringBuilder();
        line = reader.readLine();
        while (StringUtils.hasText((String)line)) {
            bodyBuilder.append(line).append(System.getProperty("line.separator"));
            line = reader.readLine();
        }
        message.setPayload(bodyBuilder.toString().trim());
        return message;
    }
}

