/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.interceptor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.citrusframework.context.TestContextFactory;
import org.citrusframework.message.Message;
import org.citrusframework.message.RawMessage;
import org.citrusframework.report.MessageListeners;
import org.citrusframework.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class LoggingClientInterceptor
implements ClientHttpRequestInterceptor {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Logger logger = LoggerFactory.getLogger(LoggingClientInterceptor.class);
    private MessageListeners messageListener;
    private final TestContextFactory contextFactory = TestContextFactory.newInstance();

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        this.handleRequest(this.getRequestContent(request, new String(body)));
        ClientHttpResponse response = execution.execute(request, body);
        CachingClientHttpResponseWrapper bufferedResponse = new CachingClientHttpResponseWrapper(response);
        this.handleResponse(this.getResponseContent(bufferedResponse));
        return bufferedResponse;
    }

    public void handleRequest(String request) {
        if (this.hasMessageListeners()) {
            logger.debug("Sending Http request message");
            this.messageListener.onOutboundMessage((Message)new RawMessage(request), this.contextFactory.getObject());
        } else if (logger.isDebugEnabled()) {
            logger.debug("Sending Http request message:" + NEWLINE + request);
        }
    }

    public void handleResponse(String response) {
        if (this.hasMessageListeners()) {
            logger.debug("Received Http response message");
            this.messageListener.onInboundMessage((Message)new RawMessage(response), this.contextFactory.getObject());
        } else if (logger.isDebugEnabled()) {
            logger.debug("Received Http response message:" + NEWLINE + response);
        }
    }

    public boolean hasMessageListeners() {
        return this.messageListener != null && !this.messageListener.isEmpty();
    }

    private String getRequestContent(HttpRequest request, String body) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getMethod());
        builder.append(" ");
        builder.append(request.getURI());
        builder.append(NEWLINE);
        this.appendHeaders(request.getHeaders(), builder);
        builder.append(NEWLINE);
        builder.append(body);
        return builder.toString();
    }

    private String getResponseContent(CachingClientHttpResponseWrapper response) throws IOException {
        if (response != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("HTTP/1.1 ");
            builder.append(response.getStatusCode());
            builder.append(" ");
            builder.append(response.getStatusText());
            builder.append(NEWLINE);
            this.appendHeaders(response.getHeaders(), builder);
            builder.append(NEWLINE);
            builder.append(response.getBodyContent());
            return builder.toString();
        }
        return "";
    }

    private void appendHeaders(HttpHeaders headers, StringBuilder builder) {
        for (Map.Entry headerEntry : headers.entrySet()) {
            builder.append((String)headerEntry.getKey());
            builder.append(":");
            builder.append(((List)headerEntry.getValue()).stream().collect(Collectors.joining(",")));
            builder.append(NEWLINE);
        }
    }

    public void setMessageListener(MessageListeners messageListener) {
        this.messageListener = messageListener;
    }

    private static final class CachingClientHttpResponseWrapper
    implements ClientHttpResponse {
        private final ClientHttpResponse response;
        private byte[] body;

        CachingClientHttpResponseWrapper(ClientHttpResponse response) {
            this.response = response;
        }

        public HttpStatusCode getStatusCode() throws IOException {
            return this.response.getStatusCode();
        }

        public int getRawStatusCode() throws IOException {
            return this.response.getRawStatusCode();
        }

        public String getStatusText() throws IOException {
            return this.response.getStatusText();
        }

        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }

        public InputStream getBody() throws IOException {
            if (this.body == null) {
                this.body = FileUtils.copyToByteArray((InputStream)this.response.getBody());
            }
            return new ByteArrayInputStream(this.body);
        }

        public String getBodyContent() throws IOException {
            if (this.body == null) {
                this.getBody();
            }
            return new String(this.body, StandardCharsets.UTF_8);
        }

        public void close() {
            this.response.close();
        }
    }
}

