/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.MappedInterceptor;
import org.springframework.web.util.UrlPathHelper;

public class MappedInterceptorAdapter
implements HandlerInterceptor {
    private final MappedInterceptor mappedInterceptor;
    private final UrlPathHelper urlPathHelper;
    private final PathMatcher pathMatcher;

    public MappedInterceptorAdapter(MappedInterceptor mappedInterceptor, UrlPathHelper urlPathHelper, PathMatcher pathMatcher) {
        this.mappedInterceptor = mappedInterceptor;
        this.urlPathHelper = urlPathHelper;
        this.pathMatcher = pathMatcher;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.mappedInterceptor.matches(this.urlPathHelper.getLookupPathForRequest(request), this.pathMatcher)) {
            return this.mappedInterceptor.getInterceptor().preHandle(request, response, handler);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (this.mappedInterceptor.matches(this.urlPathHelper.getLookupPathForRequest(request), this.pathMatcher)) {
            this.mappedInterceptor.getInterceptor().postHandle(request, response, handler, modelAndView);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (this.mappedInterceptor.matches(this.urlPathHelper.getLookupPathForRequest(request), this.pathMatcher)) {
            this.mappedInterceptor.getInterceptor().afterCompletion(request, response, handler, ex);
        }
    }
}

