/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.message;

import jakarta.servlet.http.Cookie;
import java.util.LinkedList;
import java.util.List;
import org.citrusframework.context.TestContext;

class CookieEnricher {
    CookieEnricher() {
    }

    List<Cookie> enrich(List<Cookie> cookies, TestContext context) {
        LinkedList<Cookie> enrichedCookies = new LinkedList<Cookie>();
        for (Cookie cookie : cookies) {
            Cookie enrichedCookie = new Cookie(cookie.getName(), cookie.getValue());
            if (cookie.getValue() != null) {
                enrichedCookie.setValue(context.replaceDynamicContentInString(cookie.getValue()));
            }
            if (cookie.getComment() != null) {
                enrichedCookie.setComment(context.replaceDynamicContentInString(cookie.getComment()));
            }
            if (cookie.getPath() != null) {
                enrichedCookie.setPath(context.replaceDynamicContentInString(cookie.getPath()));
            }
            if (cookie.getDomain() != null) {
                enrichedCookie.setDomain(context.replaceDynamicContentInString(cookie.getDomain()));
            }
            enrichedCookie.setMaxAge(cookie.getMaxAge());
            enrichedCookie.setVersion(cookie.getVersion());
            enrichedCookie.setHttpOnly(cookie.isHttpOnly());
            enrichedCookie.setSecure(cookie.getSecure());
            enrichedCookies.add(enrichedCookie);
        }
        return enrichedCookies;
    }
}

