/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.message;

import jakarta.servlet.http.Cookie;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.citrusframework.context.TestContext;
import org.citrusframework.http.client.HttpEndpointConfiguration;
import org.citrusframework.http.message.CookieConverter;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageConverter;
import org.citrusframework.message.MessageHeaderUtils;
import org.citrusframework.util.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMethod;

public class HttpMessageConverter
implements MessageConverter<HttpEntity<?>, HttpEntity<?>, HttpEndpointConfiguration> {
    private final CookieConverter cookieConverter;

    public HttpMessageConverter() {
        this.cookieConverter = new CookieConverter();
    }

    public HttpMessageConverter(CookieConverter cookieConverter) {
        this.cookieConverter = cookieConverter;
    }

    public HttpEntity<?> convertOutbound(Message message, HttpEndpointConfiguration endpointConfiguration, TestContext context) {
        HttpMessage httpMessage = this.convertOutboundMessage(message);
        HttpHeaders httpHeaders = this.createHttpHeaders(httpMessage, endpointConfiguration);
        Object payload = httpMessage.getPayload();
        if (httpMessage.getStatusCode() != null) {
            return new ResponseEntity(payload, (MultiValueMap)httpHeaders, httpMessage.getStatusCode());
        }
        for (Cookie cookie : httpMessage.getCookies()) {
            httpHeaders.add("Cookie", cookie.getName() + "=" + context.replaceDynamicContentInString(cookie.getValue()));
        }
        RequestMethod method = this.determineRequestMethod(endpointConfiguration, httpMessage);
        return this.createHttpEntity(httpHeaders, payload, method);
    }

    public HttpMessage convertInbound(HttpEntity<?> message, HttpEndpointConfiguration endpointConfiguration, TestContext context) {
        Map mappedHeaders = endpointConfiguration.getHeaderMapper().toHeaders((Object)message.getHeaders());
        HttpMessage httpMessage = new HttpMessage(this.extractMessageBody(message), this.convertHeaderTypes(mappedHeaders));
        for (Map.Entry<String, String> customHeader : this.getCustomHeaders(message.getHeaders(), mappedHeaders).entrySet()) {
            httpMessage.setHeader(customHeader.getKey(), customHeader.getValue());
        }
        if (message instanceof ResponseEntity) {
            httpMessage.status(((ResponseEntity)message).getStatusCode());
            httpMessage.version("HTTP/1.1");
            if (endpointConfiguration.isHandleCookies()) {
                httpMessage.setCookies(this.cookieConverter.convertCookies(message));
            }
        }
        return httpMessage;
    }

    public void convertOutbound(HttpEntity externalMessage, Message internalMessage, HttpEndpointConfiguration endpointConfiguration, TestContext context) {
        throw new UnsupportedOperationException("HttpMessageConverter does not support predefined HttpEntity objects");
    }

    private Map<String, String> getCustomHeaders(HttpHeaders httpHeaders, Map<String, Object> mappedHeaders) {
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        for (Map.Entry header : httpHeaders.entrySet()) {
            if (mappedHeaders.containsKey(header.getKey())) continue;
            customHeaders.put((String)header.getKey(), String.join((CharSequence)",", (Iterable)header.getValue()));
        }
        return customHeaders;
    }

    private Map<String, Object> convertHeaderTypes(Map<String, Object> headers) {
        HashMap<String, Object> convertedHeaders = new HashMap<String, Object>();
        for (Map.Entry<String, Object> header : headers.entrySet()) {
            if (header.getValue() instanceof Collection) {
                Collection value = (Collection)header.getValue();
                convertedHeaders.put(header.getKey(), value.stream().map(String::valueOf).collect(Collectors.joining(",")));
                continue;
            }
            if (header.getValue() instanceof MediaType) {
                convertedHeaders.put(header.getKey(), header.getValue().toString());
                continue;
            }
            convertedHeaders.put(header.getKey(), header.getValue());
        }
        return convertedHeaders;
    }

    private HttpHeaders createHttpHeaders(HttpMessage httpMessage, HttpEndpointConfiguration endpointConfiguration) {
        HttpHeaders httpHeaders = new HttpHeaders();
        endpointConfiguration.getHeaderMapper().fromHeaders(new MessageHeaders(httpMessage.getHeaders()), (Object)httpHeaders);
        Map messageHeaders = httpMessage.getHeaders();
        for (Map.Entry header : messageHeaders.entrySet()) {
            if (((String)header.getKey()).startsWith("citrus_") || MessageHeaderUtils.isSpringInternalHeader((String)((String)header.getKey())) || httpHeaders.containsKey(header.getKey())) continue;
            httpHeaders.add((String)header.getKey(), header.getValue().toString());
        }
        if (httpHeaders.getFirst("Content-Type") == null) {
            httpHeaders.add("Content-Type", this.composeContentTypeHeaderValue(endpointConfiguration));
        }
        return httpHeaders;
    }

    private RequestMethod determineRequestMethod(HttpEndpointConfiguration endpointConfiguration, HttpMessage httpMessage) {
        RequestMethod method = endpointConfiguration.getRequestMethod();
        if (httpMessage.getRequestMethod() != null) {
            method = httpMessage.getRequestMethod();
        }
        return method;
    }

    private HttpEntity<?> createHttpEntity(HttpHeaders httpHeaders, Object payload, RequestMethod method) {
        if (this.httpMethodSupportsBody(method)) {
            return new HttpEntity(payload, (MultiValueMap)httpHeaders);
        }
        return new HttpEntity((MultiValueMap)httpHeaders);
    }

    private HttpMessage convertOutboundMessage(Message message) {
        HttpMessage httpMessage = message instanceof HttpMessage ? (HttpMessage)message : new HttpMessage(message);
        return httpMessage;
    }

    private boolean httpMethodSupportsBody(RequestMethod method) {
        return RequestMethod.POST.equals((Object)method) || RequestMethod.PUT.equals((Object)method) || RequestMethod.DELETE.equals((Object)method) || RequestMethod.PATCH.equals((Object)method);
    }

    private String composeContentTypeHeaderValue(HttpEndpointConfiguration endpointConfiguration) {
        return endpointConfiguration.getContentType().contains("charset") || !StringUtils.hasText((String)endpointConfiguration.getCharset()) ? endpointConfiguration.getContentType() : endpointConfiguration.getContentType() + ";charset=" + endpointConfiguration.getCharset();
    }

    private Object extractMessageBody(HttpEntity<?> message) {
        return message.getBody() != null ? message.getBody() : "";
    }
}

