/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.config.annotation;

import java.util.ArrayList;
import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.http.client.HttpClientBuilder;
import org.citrusframework.http.config.annotation.HttpClientConfig;
import org.citrusframework.http.message.HttpMessageConverter;
import org.citrusframework.message.MessageCorrelator;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class HttpClientConfigParser
implements AnnotationConfigParser<HttpClientConfig, HttpClient> {
    public HttpClient parse(HttpClientConfig annotation, ReferenceResolver referenceResolver) {
        HttpClientBuilder builder = new HttpClientBuilder();
        if (StringUtils.hasText((String)annotation.restTemplate()) && StringUtils.hasText((String)annotation.requestFactory())) {
            throw new CitrusRuntimeException("When providing a 'rest-template' property, no 'request-factory' should be set!");
        }
        if (!StringUtils.hasText((String)annotation.requestUrl()) && !StringUtils.hasText((String)annotation.endpointResolver())) {
            throw new CitrusRuntimeException("One of the properties 'request-url' or 'endpoint-resolver' is required!");
        }
        if (StringUtils.hasText((String)annotation.restTemplate())) {
            builder.restTemplate((RestTemplate)referenceResolver.resolve(annotation.restTemplate(), RestTemplate.class));
        }
        if (StringUtils.hasText((String)annotation.requestFactory())) {
            builder.requestFactory((ClientHttpRequestFactory)referenceResolver.resolve(annotation.requestFactory(), ClientHttpRequestFactory.class));
        }
        builder.requestUrl(annotation.requestUrl());
        builder.requestMethod(annotation.requestMethod());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((HttpMessageConverter)referenceResolver.resolve(annotation.messageConverter(), HttpMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)referenceResolver.resolve(annotation.correlator(), MessageCorrelator.class));
        }
        if (StringUtils.hasText((String)annotation.endpointResolver())) {
            builder.endpointResolver((EndpointUriResolver)referenceResolver.resolve(annotation.endpointResolver(), EndpointUriResolver.class));
        }
        builder.defaultAcceptHeader(annotation.defaultAcceptHeader());
        builder.handleCookies(annotation.handleCookies());
        builder.charset(annotation.charset());
        builder.contentType(annotation.contentType());
        builder.pollingInterval(annotation.pollingInterval());
        builder.errorHandlingStrategy(annotation.errorStrategy());
        if (StringUtils.hasText((String)annotation.errorHandler())) {
            builder.errorHandler((ResponseErrorHandler)referenceResolver.resolve(annotation.errorHandler(), ResponseErrorHandler.class));
        }
        ArrayList<MediaType> binaryMediaTypes = new ArrayList<MediaType>();
        for (String mediaType : annotation.binaryMediaTypes()) {
            binaryMediaTypes.add(MediaType.valueOf((String)mediaType));
        }
        if (!binaryMediaTypes.isEmpty()) {
            builder.binaryMediaTypes(binaryMediaTypes);
        }
        if (annotation.interceptors().length > 0) {
            builder.interceptors(referenceResolver.resolve(annotation.interceptors(), ClientHttpRequestInterceptor.class));
        }
        builder.headerMapper(DefaultHttpHeaderMapper.outboundMapper());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (HttpClient)builder.initialize().build();
    }
}

