/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.server;

import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.context.SpringBeanReferenceResolver;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.context.ParentDelegatingWebApplicationContext;
import org.citrusframework.http.interceptor.LoggingHandlerInterceptor;
import org.citrusframework.http.message.HttpMessageConverter;
import org.citrusframework.http.server.HttpServerSettings;
import org.citrusframework.http.servlet.CitrusDispatcherServlet;
import org.citrusframework.http.servlet.GzipServletFilter;
import org.citrusframework.http.servlet.RequestCachingServletFilter;
import org.citrusframework.report.MessageListeners;
import org.citrusframework.server.AbstractServer;
import org.citrusframework.util.StringUtils;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class HttpServer
extends AbstractServer {
    private int port = 8080;
    private String resourceBase = "src/main/resources";
    private String contextConfigLocation = "classpath:org/citrusframework/http/citrus-servlet-context.xml";
    private Server jettyServer;
    private boolean useRootContextAsParent = false;
    private static final Object serverLock = new Object();
    private Connector connector;
    private Connector[] connectors;
    private Map<String, Filter> filters = new HashMap<String, Filter>();
    private Map<String, String> filterMappings = new HashMap<String, String>();
    private String servletMappingPath = "/*";
    private String servletName;
    private String contextPath = "/";
    private SecurityHandler securityHandler;
    private ServletHandler servletHandler;
    private boolean handleAttributeHeaders = false;
    private boolean handleCookies = false;
    private int defaultStatusCode = HttpStatus.OK.value();
    private int responseCacheSize = HttpServerSettings.responseCacheSize();
    private List<MediaType> binaryMediaTypes = Arrays.asList(MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_PDF, MediaType.IMAGE_GIF, MediaType.IMAGE_JPEG, MediaType.IMAGE_PNG, MediaType.valueOf((String)"application/zip"));
    private HttpMessageConverter messageConverter = new HttpMessageConverter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        if (this.jettyServer != null) {
            try {
                Object object = serverLock;
                synchronized (object) {
                    this.jettyServer.stop();
                }
            }
            catch (Exception e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() {
        Object object = serverLock;
        synchronized (object) {
            if (this.connectors != null && this.connectors.length > 0) {
                this.jettyServer = this.connectors[0].getServer();
                this.jettyServer.setConnectors(this.connectors);
            } else if (this.connector != null) {
                this.jettyServer = this.connector.getServer();
                this.jettyServer.addConnector(this.connector);
            } else {
                this.jettyServer = new Server(this.port);
            }
            HandlerCollection handlers = new HandlerCollection();
            ContextHandlerCollection contextCollection = new ContextHandlerCollection();
            ServletContextHandler contextHandler = new ServletContextHandler();
            contextHandler.setContextPath(this.contextPath);
            contextHandler.setResourceBase(this.resourceBase);
            if (this.useRootContextAsParent && this.getReferenceResolver() instanceof SpringBeanReferenceResolver) {
                contextHandler.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)new ParentDelegatingWebApplicationContext(((SpringBeanReferenceResolver)this.getReferenceResolver()).getApplicationContext()));
            }
            if (this.servletHandler == null) {
                this.servletHandler = new ServletHandler();
                this.addDispatcherServlet();
            }
            for (Map.Entry<String, Filter> filterEntry : this.filters.entrySet()) {
                String filterMappingPathSpec = this.filterMappings.get(filterEntry.getKey());
                FilterMapping filterMapping = new FilterMapping();
                filterMapping.setFilterName(filterEntry.getKey());
                filterMapping.setPathSpec(StringUtils.hasText((String)filterMappingPathSpec) ? filterMappingPathSpec : "/*");
                FilterHolder filterHolder = new FilterHolder();
                filterHolder.setName(filterEntry.getKey());
                filterHolder.setFilter(filterEntry.getValue());
                this.servletHandler.addFilter(filterHolder, filterMapping);
            }
            if (this.filters == null || this.filters.isEmpty()) {
                this.addRequestCachingFilter();
                this.addGzipFilter();
            }
            contextHandler.setServletHandler(this.servletHandler);
            if (this.securityHandler != null) {
                contextHandler.setSecurityHandler(this.securityHandler);
            }
            this.configure(contextHandler);
            contextCollection.addHandler((Handler)contextHandler);
            handlers.addHandler((Handler)contextCollection);
            handlers.addHandler((Handler)new DefaultHandler());
            handlers.addHandler((Handler)new RequestLogHandler());
            this.jettyServer.setHandler((Handler)handlers);
            try {
                this.jettyServer.start();
            }
            catch (Exception e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    protected void configure(ServletContextHandler contextHandler) {
    }

    public void initialize() {
        super.initialize();
        if (this.getReferenceResolver() != null && this.getReferenceResolver().resolveAll(MessageListeners.class).size() == 1) {
            MessageListeners messageListeners = (MessageListeners)this.getReferenceResolver().resolve(MessageListeners.class);
            this.getInterceptors().stream().filter(LoggingHandlerInterceptor.class::isInstance).map(LoggingHandlerInterceptor.class::cast).filter(interceptor -> !interceptor.hasMessageListeners()).forEach(interceptor -> interceptor.setMessageListener(messageListeners));
        }
    }

    private void addDispatcherServlet() {
        ServletHolder servletHolder = new ServletHolder((Servlet)this.getDispatcherServlet());
        servletHolder.setName(this.getServletName());
        servletHolder.setInitParameter("contextConfigLocation", this.contextConfigLocation);
        this.servletHandler.addServlet(servletHolder);
        ServletMapping servletMapping = new ServletMapping();
        servletMapping.setServletName(this.getServletName());
        servletMapping.setPathSpec(this.servletMappingPath);
        this.servletHandler.addServletMapping(servletMapping);
    }

    protected DispatcherServlet getDispatcherServlet() {
        return new CitrusDispatcherServlet(this);
    }

    private void addRequestCachingFilter() {
        FilterMapping filterMapping = new FilterMapping();
        filterMapping.setFilterName("request-caching-filter");
        filterMapping.setPathSpec("/*");
        FilterHolder filterHolder = new FilterHolder((Filter)new RequestCachingServletFilter());
        filterHolder.setName("request-caching-filter");
        this.servletHandler.addFilter(filterHolder, filterMapping);
    }

    private void addGzipFilter() {
        FilterMapping filterMapping = new FilterMapping();
        filterMapping.setFilterName("gzip-filter");
        filterMapping.setPathSpec("/*");
        FilterHolder filterHolder = new FilterHolder((Filter)new GzipServletFilter());
        filterHolder.setName("gzip-filter");
        this.servletHandler.addFilter(filterHolder, filterMapping);
    }

    public String getServletName() {
        if (StringUtils.hasText((String)this.servletName)) {
            return this.servletName;
        }
        return this.getName() + "-servlet";
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setFilters(Map<String, Filter> filters) {
        this.filters = filters;
    }

    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public void setFilterMappings(Map<String, String> filterMappings) {
        this.filterMappings = filterMappings;
    }

    public Map<String, String> getFilterMappings() {
        return this.filterMappings;
    }

    public Connector[] getConnectors() {
        if (this.connectors != null) {
            return Arrays.copyOf(this.connectors, this.connectors.length);
        }
        return new Connector[0];
    }

    public void setConnectors(Connector[] connectors) {
        this.connectors = Arrays.copyOf(connectors, connectors.length);
    }

    public String getServletMappingPath() {
        return this.servletMappingPath;
    }

    public void setServletMappingPath(String servletMappingPath) {
        this.servletMappingPath = servletMappingPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this.securityHandler = securityHandler;
    }

    public ServletHandler getServletHandler() {
        return this.servletHandler;
    }

    public void setServletHandler(ServletHandler servletHandler) {
        this.servletHandler = servletHandler;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public boolean isUseRootContextAsParent() {
        return this.useRootContextAsParent;
    }

    public void setUseRootContextAsParent(boolean useRootContextAsParent) {
        this.useRootContextAsParent = useRootContextAsParent;
    }

    public HttpMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(HttpMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public boolean isHandleAttributeHeaders() {
        return this.handleAttributeHeaders;
    }

    public void setHandleAttributeHeaders(boolean handleAttributeHeaders) {
        this.handleAttributeHeaders = handleAttributeHeaders;
    }

    public boolean isHandleCookies() {
        return this.handleCookies;
    }

    public void setHandleCookies(boolean handleCookies) {
        this.handleCookies = handleCookies;
    }

    public int getResponseCacheSize() {
        return this.responseCacheSize;
    }

    public void setResponseCacheSize(int responseCacheSize) {
        this.responseCacheSize = responseCacheSize;
    }

    public int getDefaultStatusCode() {
        return this.defaultStatusCode;
    }

    public void setDefaultStatusCode(int defaultStatusCode) {
        this.defaultStatusCode = defaultStatusCode;
    }

    public List<MediaType> getBinaryMediaTypes() {
        return this.binaryMediaTypes;
    }

    public void setBinaryMediaTypes(List<MediaType> binaryMediaTypes) {
        this.binaryMediaTypes = binaryMediaTypes;
    }
}

