/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.servlet;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.citrusframework.exceptions.CitrusRuntimeException;

public class GzipHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public GzipHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        return new GzipServletInputStream(this.getRequest());
    }

    private class GzipServletInputStream
    extends ServletInputStream {
        private final GZIPInputStream gzipStream;

        public GzipServletInputStream(ServletRequest request) throws IOException {
            this.gzipStream = new GZIPInputStream((InputStream)request.getInputStream());
        }

        public boolean isFinished() {
            try {
                return this.gzipStream.available() == 0;
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to check gzip input stream availability", (Throwable)e);
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException("Unsupported operation");
        }

        public int read() {
            try {
                return this.gzipStream.read();
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read gzip input stream", (Throwable)e);
            }
        }

        public int read(byte[] b) throws IOException {
            return this.gzipStream.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.gzipStream.read(b, off, len);
        }
    }
}

