/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.config.annotation;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.TestActor;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.endpoint.EndpointAdapter;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.config.annotation.HttpServerConfig;
import org.citrusframework.http.message.HttpMessageConverter;
import org.citrusframework.http.security.HttpAuthentication;
import org.citrusframework.http.security.HttpSecureConnection;
import org.citrusframework.http.server.HttpServer;
import org.citrusframework.http.server.HttpServerBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.StringUtils;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.HandlerInterceptor;

public class HttpServerConfigParser
implements AnnotationConfigParser<HttpServerConfig, HttpServer> {
    public HttpServer parse(HttpServerConfig annotation, ReferenceResolver referenceResolver) {
        HttpServerBuilder builder = new HttpServerBuilder();
        builder.autoStart(annotation.autoStart());
        builder.timeout(annotation.timeout());
        builder.handleAttributeHeaders(annotation.handleAttributeHeaders());
        builder.handleCookies(annotation.handleCookies());
        builder.debugLogging(annotation.debugLogging());
        if (StringUtils.hasText((String)annotation.endpointAdapter())) {
            builder.endpointAdapter((EndpointAdapter)referenceResolver.resolve(annotation.endpointAdapter(), EndpointAdapter.class));
        }
        builder.interceptors(referenceResolver.resolve(annotation.interceptors(), HandlerInterceptor.class));
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        builder.port(annotation.port());
        if (StringUtils.hasText((String)annotation.contextConfigLocation())) {
            builder.contextConfigLocation(annotation.contextConfigLocation());
        }
        if (StringUtils.hasText((String)annotation.resourceBase())) {
            builder.resourceBase(annotation.resourceBase());
        }
        builder.rootParentContext(annotation.rootParentContext());
        builder.connectors(referenceResolver.resolve(annotation.connectors(), Connector.class));
        if (annotation.filters().length > 0) {
            builder.filters(referenceResolver.resolveAll(Filter.class).entrySet().stream().filter(entry -> Stream.of(annotation.filters()).anyMatch(f -> f.equals(entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }
        HashMap<String, String> filterMappings = new HashMap<String, String>();
        for (String filterMapping : annotation.filterMappings()) {
            String[] pair = filterMapping.split("=");
            if (pair.length != 2) {
                throw new CitrusRuntimeException("Invalid filter mapping: " + filterMapping);
            }
            filterMappings.put(pair[0], pair[1]);
        }
        builder.filterMappings(filterMappings);
        ArrayList<MediaType> binaryMediaTypes = new ArrayList<MediaType>();
        for (String mediaType : annotation.binaryMediaTypes()) {
            binaryMediaTypes.add(MediaType.valueOf((String)mediaType));
        }
        if (!binaryMediaTypes.isEmpty()) {
            builder.binaryMediaTypes(binaryMediaTypes);
        }
        if (StringUtils.hasText((String)annotation.connector())) {
            builder.connector((Connector)referenceResolver.resolve(annotation.connector(), Connector.class));
        }
        if (StringUtils.hasText((String)annotation.servletName())) {
            builder.servletName(annotation.servletName());
        }
        if (StringUtils.hasText((String)annotation.servletMappingPath())) {
            builder.servletMappingPath(annotation.servletMappingPath());
        }
        if (StringUtils.hasText((String)annotation.contextPath())) {
            builder.contextPath(annotation.contextPath());
        }
        if (StringUtils.hasText((String)annotation.servletHandler())) {
            builder.servletHandler((ServletHandler)referenceResolver.resolve(annotation.servletHandler(), ServletHandler.class));
        }
        if (StringUtils.hasText((String)annotation.securityHandler())) {
            builder.securityHandler((SecurityHandler)referenceResolver.resolve(annotation.securityHandler(), SecurityHandler.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((HttpMessageConverter)referenceResolver.resolve(annotation.messageConverter(), HttpMessageConverter.class));
        }
        builder.defaultStatus(annotation.defaultStatus());
        builder.responseCacheSize(annotation.responseCacheSize());
        if (StringUtils.hasText((String)annotation.authentication())) {
            builder.authentication(annotation.securedPath(), (HttpAuthentication)referenceResolver.resolve(annotation.authentication(), HttpAuthentication.class));
        }
        if (StringUtils.hasText((String)annotation.secured())) {
            builder.secured(annotation.securePort(), (HttpSecureConnection)referenceResolver.resolve(annotation.secured(), HttpSecureConnection.class));
        }
        return (HttpServer)builder.initialize().build();
    }
}

