/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.security;

import java.net.URL;
import java.util.Collections;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.client.BasicAuthClientHttpRequestFactory;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.http.security.BasicAuthConstraint;
import org.citrusframework.http.security.HttpAuthentication;
import org.citrusframework.http.security.SecurityHandlerFactory;
import org.citrusframework.http.security.User;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.StringUtils;

public class BasicAuthentication
implements HttpAuthentication {
    private final String username;
    private final String password;
    private String realm = "";
    private String[] userRoles = new String[]{"citrus"};

    public BasicAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public SecurityHandler getSecurityHandler(String resourcePath) {
        try {
            SecurityHandlerFactory securityHandlerFactory = new SecurityHandlerFactory();
            securityHandlerFactory.setUsers(Collections.singletonList(new User(this.username, this.password, this.userRoles)));
            securityHandlerFactory.setConstraints(Collections.singletonMap(resourcePath, new BasicAuthConstraint(this.userRoles)));
            securityHandlerFactory.setAuthenticator((Authenticator)new BasicAuthenticator());
            securityHandlerFactory.setRealm(this.realm);
            securityHandlerFactory.initialize();
            return securityHandlerFactory.getObject();
        }
        catch (Exception e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    @Override
    public ClientHttpRequestFactory getRequestFactory(String requestUrl, HttpClient httpClient) {
        try {
            BasicAuthClientHttpRequestFactory requestFactory = new BasicAuthClientHttpRequestFactory();
            if (httpClient != null) {
                requestFactory.setHttpClient(httpClient.getEndpointConfiguration().getHttpClient());
            }
            URL url = null;
            if (StringUtils.hasText((String)requestUrl)) {
                url = new URL(requestUrl);
            } else if (httpClient != null && StringUtils.hasText((String)httpClient.getEndpointConfiguration().getRequestUrl())) {
                url = new URL(httpClient.getEndpointConfiguration().getRequestUrl());
            }
            if (url != null) {
                AuthScope authScope = new AuthScope(url.getProtocol(), url.getHost(), url.getPort(), this.realm, "basic");
                requestFactory.setAuthScope(authScope);
            }
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password.toCharArray());
            requestFactory.setCredentials((Credentials)credentials);
            requestFactory.initialize();
            return requestFactory.getObject();
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to configure basic auth on Http client", (Throwable)e);
        }
    }

    public BasicAuthentication realm(String realm) {
        this.realm = realm;
        return this;
    }

    public BasicAuthentication userRoles(String ... roles) {
        this.userRoles = roles;
        return this;
    }
}

