/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.citrusframework.context.TestContextFactory;
import org.citrusframework.http.controller.HttpMessageController;
import org.citrusframework.message.Message;
import org.citrusframework.message.RawMessage;
import org.citrusframework.report.MessageListeners;
import org.citrusframework.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LoggingHandlerInterceptor
implements HandlerInterceptor {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Logger logger = LoggerFactory.getLogger(LoggingHandlerInterceptor.class);
    private MessageListeners messageListener;
    private final TestContextFactory contextFactory = TestContextFactory.newInstance();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.handleRequest(this.getRequestContent(request));
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.handleResponse(this.getResponseContent(request, response, handler));
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public void handleRequest(String request) {
        if (this.hasMessageListeners()) {
            logger.debug("Received Http request");
            this.messageListener.onInboundMessage((Message)new RawMessage(request), this.contextFactory.getObject());
        } else if (logger.isDebugEnabled()) {
            logger.debug("Received Http request:" + NEWLINE + request);
        }
    }

    public void handleResponse(String response) {
        if (this.hasMessageListeners()) {
            logger.debug("Sending Http response");
            this.messageListener.onOutboundMessage((Message)new RawMessage(response), this.contextFactory.getObject());
        } else if (logger.isDebugEnabled()) {
            logger.debug("Sending Http response:" + NEWLINE + response);
        }
    }

    public boolean hasMessageListeners() {
        return this.messageListener != null && !this.messageListener.isEmpty();
    }

    private String getRequestContent(HttpServletRequest request) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getProtocol());
        builder.append(" ");
        builder.append(request.getMethod());
        builder.append(" ");
        builder.append(request.getRequestURI());
        builder.append(NEWLINE);
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement().toString();
            builder.append(headerName);
            builder.append(":");
            Enumeration headerValues = request.getHeaders(headerName);
            if (headerValues.hasMoreElements()) {
                builder.append(headerValues.nextElement());
            }
            while (headerValues.hasMoreElements()) {
                builder.append(",");
                builder.append(headerValues.nextElement());
            }
            builder.append(NEWLINE);
        }
        builder.append(NEWLINE);
        builder.append(FileUtils.readToString((InputStream)request.getInputStream()));
        return builder.toString();
    }

    private String getResponseContent(HttpServletRequest request, HttpServletResponse response, Object handler) {
        ResponseEntity<?> responseEntity;
        HandlerMethod handlerMethod;
        StringBuilder builder = new StringBuilder();
        builder.append(response);
        if (handler instanceof HandlerMethod && (handlerMethod = (HandlerMethod)handler).getBean() instanceof HttpMessageController && (responseEntity = ((HttpMessageController)handlerMethod.getBean()).getResponseCache(request)) != null) {
            builder.append(NEWLINE);
            builder.append(responseEntity.getBody());
        }
        return builder.toString();
    }

    public void setMessageListener(MessageListeners messageListener) {
        this.messageListener = messageListener;
    }
}

