/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.security;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.citrusframework.http.security.HttpSecureConnection;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.beans.factory.BeanCreationException;

public class SSLConnection
implements HttpSecureConnection {
    private Resource keyStore;
    private String keyStorePassword;
    private Resource trustStore;
    private String trustStorePassword;
    private HostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;

    public SSLConnection() {
    }

    public SSLConnection(Resource keyStore, String password) {
        this.keyStore = keyStore;
        this.keyStorePassword = password;
    }

    public SSLConnection(Resource keyStore, String ksPassword, Resource trustStore, String tsPassword) {
        this.keyStore = keyStore;
        this.keyStorePassword = ksPassword;
        this.trustStore = trustStore;
        this.trustStorePassword = tsPassword;
    }

    @Override
    public ServerConnector getServerConnector(int securePort) {
        ServerConnector connector = new ServerConnector(new Server(), new ConnectionFactory[]{new SslConnectionFactory(this.sslContextFactory(), HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(this.httpConfiguration(securePort))});
        connector.setPort(securePort);
        return connector;
    }

    @Override
    public HttpClientConnectionManager getClientConnectionManager() {
        try {
            SSLContextBuilder sslContext = this.trustStore != null ? SSLContexts.custom().loadTrustMaterial(this.trustStore.getFile(), this.trustStorePassword.toCharArray(), (TrustStrategy)new TrustSelfSignedStrategy()) : SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE);
            if (this.keyStore != null) {
                sslContext.loadKeyMaterial(KeyStore.getInstance(this.keyStore.getFile(), this.keyStorePassword.toCharArray()), this.keyStorePassword.toCharArray());
            }
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext.build(), this.hostnameVerifier);
            return PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new BeanCreationException("Failed to create http client for ssl connection", (Throwable)e);
        }
    }

    public SSLConnection trustStore(String trustStore, String password) {
        return this.trustStore(Resources.create((String)trustStore), password);
    }

    public SSLConnection trustStore(Resource trustStore, String password) {
        this.trustStore = trustStore;
        this.trustStorePassword = password;
        return this;
    }

    public SSLConnection keyStore(String keyStore, String password) {
        return this.keyStore(Resources.create((String)keyStore), password);
    }

    public SSLConnection keyStore(Resource keyStore, String password) {
        this.keyStore = keyStore;
        this.keyStorePassword = password;
        return this;
    }

    public SSLConnection hostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
        return this;
    }

    private SslContextFactory.Server sslContextFactory() {
        SslContextFactory.Server contextFactory = new SslContextFactory.Server();
        if (this.trustStore != null) {
            contextFactory.setTrustStorePath(this.trustStore.getFile().getPath());
            contextFactory.setTrustStorePassword(this.trustStorePassword);
        } else {
            contextFactory.setTrustAll(true);
        }
        if (this.keyStore != null) {
            contextFactory.setKeyStorePath(this.keyStore.getFile().getPath());
            contextFactory.setKeyStorePassword(this.keyStorePassword);
        }
        return contextFactory;
    }

    private HttpConfiguration httpConfiguration(int securePort) {
        HttpConfiguration parent = new HttpConfiguration();
        parent.setSecureScheme("https");
        parent.setSecurePort(securePort);
        HttpConfiguration configuration = new HttpConfiguration(parent);
        SecureRequestCustomizer secureRequestCustomizer = new SecureRequestCustomizer();
        secureRequestCustomizer.setSniHostCheck(false);
        configuration.setCustomizers(Collections.singletonList(secureRequestCustomizer));
        return configuration;
    }
}

