/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.client;

import java.util.List;
import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.http.message.HttpMessageConverter;
import org.citrusframework.http.security.HttpAuthentication;
import org.citrusframework.http.security.HttpSecureConnection;
import org.citrusframework.message.ErrorHandlingStrategy;
import org.citrusframework.message.MessageCorrelator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class HttpClientBuilder
extends AbstractEndpointBuilder<HttpClient> {
    private final HttpClient endpoint = new HttpClient();

    protected HttpClient getEndpoint() {
        return this.endpoint;
    }

    public HttpClientBuilder requestUrl(String uri) {
        this.endpoint.getEndpointConfiguration().setRequestUrl(uri);
        return this;
    }

    public HttpClientBuilder restTemplate(RestTemplate restTemplate) {
        this.endpoint.getEndpointConfiguration().setRestTemplate(restTemplate);
        return this;
    }

    public HttpClientBuilder requestFactory(ClientHttpRequestFactory requestFactory) {
        this.endpoint.getEndpointConfiguration().setRequestFactory(requestFactory);
        return this;
    }

    public HttpClientBuilder requestMethod(RequestMethod requestMethod) {
        this.endpoint.getEndpointConfiguration().setRequestMethod(requestMethod);
        return this;
    }

    public HttpClientBuilder messageConverter(HttpMessageConverter messageConverter) {
        this.endpoint.getEndpointConfiguration().setMessageConverter(messageConverter);
        return this;
    }

    public HttpClientBuilder correlator(MessageCorrelator correlator) {
        this.endpoint.getEndpointConfiguration().setCorrelator(correlator);
        return this;
    }

    public HttpClientBuilder endpointResolver(EndpointUriResolver resolver) {
        this.endpoint.getEndpointConfiguration().setEndpointUriResolver(resolver);
        return this;
    }

    public HttpClientBuilder charset(String charset) {
        this.endpoint.getEndpointConfiguration().setCharset(charset);
        return this;
    }

    public HttpClientBuilder defaultAcceptHeader(boolean flag) {
        this.endpoint.getEndpointConfiguration().setDefaultAcceptHeader(flag);
        return this;
    }

    public HttpClientBuilder handleCookies(boolean flag) {
        this.endpoint.getEndpointConfiguration().setHandleCookies(flag);
        return this;
    }

    public HttpClientBuilder disableRedirectHandling(boolean flag) {
        this.endpoint.getEndpointConfiguration().setDisableRedirectHandling(flag);
        return this;
    }

    public HttpClientBuilder contentType(String contentType) {
        this.endpoint.getEndpointConfiguration().setContentType(contentType);
        return this;
    }

    public HttpClientBuilder pollingInterval(int pollingInterval) {
        this.endpoint.getEndpointConfiguration().setPollingInterval(pollingInterval);
        return this;
    }

    public HttpClientBuilder errorHandlingStrategy(ErrorHandlingStrategy errorStrategy) {
        this.endpoint.getEndpointConfiguration().setErrorHandlingStrategy(errorStrategy);
        return this;
    }

    public HttpClientBuilder errorHandler(ResponseErrorHandler errorHandler) {
        this.endpoint.getEndpointConfiguration().setErrorHandler(errorHandler);
        return this;
    }

    public HttpClientBuilder interceptors(List<ClientHttpRequestInterceptor> interceptors) {
        this.endpoint.getEndpointConfiguration().setClientInterceptors(interceptors);
        return this;
    }

    public HttpClientBuilder binaryMediaTypes(List<MediaType> binaryMediaTypes) {
        this.endpoint.getEndpointConfiguration().setBinaryMediaTypes(binaryMediaTypes);
        return this;
    }

    public HttpClientBuilder interceptor(ClientHttpRequestInterceptor interceptor) {
        this.endpoint.getEndpointConfiguration().getClientInterceptors().add(interceptor);
        return this;
    }

    public HttpClientBuilder headerMapper(DefaultHttpHeaderMapper headerMapper) {
        this.endpoint.getEndpointConfiguration().setHeaderMapper((HeaderMapper<HttpHeaders>)headerMapper);
        return this;
    }

    public HttpClientBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }

    public HttpClientBuilder authentication(HttpAuthentication auth) {
        this.endpoint.getEndpointConfiguration().setRequestFactory(auth.getRequestFactory(this.endpoint.getEndpointConfiguration().getRequestUrl(), this.endpoint));
        return this;
    }

    public HttpClientBuilder secured(HttpSecureConnection conn) {
        this.endpoint.getEndpointConfiguration().getHttpClient().setConnectionManager(conn.getClientConnectionManager());
        return this;
    }
}

