/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.client;

import java.io.IOException;
import java.net.URI;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.client.HttpErrorPropagatingException;
import org.citrusframework.message.ErrorHandlingStrategy;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class HttpResponseErrorHandler
extends DefaultResponseErrorHandler {
    private final ErrorHandlingStrategy errorHandlingStrategy;

    public HttpResponseErrorHandler(ErrorHandlingStrategy errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
    }

    protected void handleError(ClientHttpResponse response, HttpStatusCode statusCode, @Nullable URI url, @Nullable HttpMethod method) throws IOException {
        if (this.errorHandlingStrategy.equals((Object)ErrorHandlingStrategy.PROPAGATE)) {
            throw new HttpErrorPropagatingException(response.getStatusCode(), response.getStatusText(), response.getHeaders(), this.getResponseBody(response), this.getCharset(response));
        }
        if (!this.errorHandlingStrategy.equals((Object)ErrorHandlingStrategy.THROWS_EXCEPTION)) {
            throw new CitrusRuntimeException("Unsupported error strategy: " + this.errorHandlingStrategy);
        }
        super.handleError(response);
    }
}

