/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.MappedInterceptor;

public class MappedInterceptorAdapter
implements HandlerInterceptor {
    private final MappedInterceptor mappedInterceptor;

    public MappedInterceptorAdapter(MappedInterceptor mappedInterceptor) {
        this.mappedInterceptor = mappedInterceptor;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.mappedInterceptor.matches(request)) {
            return this.mappedInterceptor.getInterceptor().preHandle(request, response, handler);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (this.mappedInterceptor.matches(request)) {
            this.mappedInterceptor.getInterceptor().postHandle(request, response, handler, modelAndView);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (this.mappedInterceptor.matches(request)) {
            this.mappedInterceptor.getInterceptor().afterCompletion(request, response, handler, ex);
        }
    }
}

