/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.actions;

import jakarta.servlet.http.Cookie;
import java.util.Optional;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.http.message.HttpMessageUtils;
import org.citrusframework.http.message.HttpQueryParamHeaderValidator;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.builder.ReceiveMessageBuilderSupport;
import org.citrusframework.validation.HeaderValidator;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;

public class HttpServerRequestActionBuilder
extends ReceiveMessageAction.ReceiveMessageActionBuilder<ReceiveMessageAction, HttpMessageBuilderSupport, HttpServerRequestActionBuilder> {
    private final HttpMessage httpMessage;

    public HttpServerRequestActionBuilder() {
        this.httpMessage = new HttpMessage();
        ((HttpMessageBuilderSupport)this.message((MessageBuilder)new HttpMessageBuilder(this.httpMessage))).headerNameIgnoreCase(true);
        this.validator((HeaderValidator)new HttpQueryParamHeaderValidator());
    }

    public HttpServerRequestActionBuilder(MessageBuilder messageBuilder, HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        ((HttpMessageBuilderSupport)this.message(messageBuilder)).headerNameIgnoreCase(true);
        this.validator((HeaderValidator)new HttpQueryParamHeaderValidator());
    }

    public HttpMessageBuilderSupport getMessageBuilderSupport() {
        if (this.messageBuilderSupport == null) {
            this.messageBuilderSupport = this.createMessageBuilderSupport();
        }
        return (HttpMessageBuilderSupport)super.getMessageBuilderSupport();
    }

    protected HttpMessageBuilderSupport createMessageBuilderSupport() {
        return new HttpMessageBuilderSupport(this.httpMessage, this);
    }

    public HttpServerRequestActionBuilder path(String path) {
        this.httpMessage.path(path);
        return this;
    }

    public HttpServerRequestActionBuilder method(HttpMethod method) {
        this.httpMessage.method(method);
        return this;
    }

    public HttpServerRequestActionBuilder queryParam(String name) {
        this.httpMessage.queryParam(name, null);
        return this;
    }

    public HttpServerRequestActionBuilder queryParam(String name, String value) {
        this.httpMessage.queryParam(name, value);
        return this;
    }

    public ReceiveMessageAction doBuild() {
        return new ReceiveMessageAction((ReceiveMessageAction.ReceiveMessageActionBuilder)this);
    }

    protected Optional<String> getMessagePayload() {
        if (this.httpMessage.getPayload() instanceof String) {
            return Optional.of((String)this.httpMessage.getPayload(String.class));
        }
        return super.getMessagePayload();
    }

    public static class HttpMessageBuilderSupport
    extends ReceiveMessageBuilderSupport<ReceiveMessageAction, HttpServerRequestActionBuilder, HttpMessageBuilderSupport> {
        private final HttpMessage httpMessage;

        protected HttpMessageBuilderSupport(HttpMessage httpMessage, HttpServerRequestActionBuilder delegate) {
            super((ReceiveMessageAction.ReceiveMessageActionBuilder)delegate);
            this.httpMessage = httpMessage;
        }

        public HttpMessageBuilderSupport body(String payload) {
            this.httpMessage.setPayload(payload);
            return this;
        }

        public HttpMessageBuilderSupport body(MultiValueMap<String, Object> payload) {
            this.httpMessage.setPayload(payload);
            return this;
        }

        public HttpMessageBuilderSupport name(String name) {
            this.httpMessage.setName(name);
            return (HttpMessageBuilderSupport)super.name(name);
        }

        public HttpMessageBuilderSupport from(Message controlMessage) {
            HttpMessageUtils.copy(controlMessage, this.httpMessage);
            return this;
        }

        public HttpMessageBuilderSupport method(HttpMethod method) {
            ((HttpServerRequestActionBuilder)this.delegate).method(method);
            return this;
        }

        public HttpMessageBuilderSupport queryParam(String name) {
            ((HttpServerRequestActionBuilder)this.delegate).queryParam(name, null);
            return this;
        }

        public HttpMessageBuilderSupport queryParam(String name, String value) {
            ((HttpServerRequestActionBuilder)this.delegate).queryParam(name, value);
            return this;
        }

        public HttpMessageBuilderSupport version(String version) {
            this.httpMessage.version(version);
            return this;
        }

        public HttpMessageBuilderSupport contentType(String contentType) {
            this.httpMessage.contentType(contentType);
            return this;
        }

        public HttpMessageBuilderSupport accept(String accept) {
            this.httpMessage.accept(accept);
            return this;
        }

        public HttpMessageBuilderSupport cookie(Cookie cookie) {
            this.httpMessage.cookie(cookie);
            return this;
        }
    }
}

