/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.config.xml;

import java.util.List;
import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.DescriptionElementParser;
import org.citrusframework.config.xml.MessageSelectorParser;
import org.citrusframework.config.xml.ReceiveMessageActionParser;
import org.citrusframework.http.config.xml.CookieUtils;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.builder.DefaultMessageBuilder;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class HttpReceiveResponseActionParser
extends ReceiveMessageActionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.createBeanDefinitionBuilder(element, parserContext);
        return builder.getBeanDefinition();
    }

    protected BeanDefinitionBuilder createBeanDefinitionBuilder(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = this.parseComponent(element, parserContext);
        builder.addPropertyValue("name", (Object)("http:" + element.getLocalName()));
        DescriptionElementParser.doParse((Element)element, (BeanDefinitionBuilder)builder);
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)builder, (String)element.getAttribute("actor"), (String)"actor");
        String receiveTimeout = element.getAttribute("timeout");
        if (StringUtils.hasText((String)receiveTimeout)) {
            builder.addPropertyValue("receiveTimeout", (Object)Long.valueOf(receiveTimeout));
        }
        this.validateEndpointConfiguration(element);
        if (element.hasAttribute("client")) {
            builder.addPropertyReference("endpoint", element.getAttribute("client"));
        } else if (element.hasAttribute("uri")) {
            builder.addPropertyValue("endpointUri", (Object)element.getAttribute("uri"));
        }
        HttpMessage httpMessage = new HttpMessage();
        Element body = DomUtils.getChildElementByTagName((Element)element, (String)"body");
        List validationContexts = this.parseValidationContexts(body, builder);
        Element headers = DomUtils.getChildElementByTagName((Element)element, (String)"headers");
        if (headers != null) {
            String version;
            String reasonPhrase;
            List headerElements = DomUtils.getChildElementsByTagName((Element)headers, (String)"header");
            for (Object headerElement : headerElements) {
                Element header = (Element)headerElement;
                httpMessage.setHeader(header.getAttribute("name"), header.getAttribute("value"));
            }
            String statusCode = headers.getAttribute("status");
            if (StringUtils.hasText((String)statusCode)) {
                httpMessage.setHeader("citrus_http_status_code", statusCode);
            }
            if (StringUtils.hasText((String)(reasonPhrase = headers.getAttribute("reason-phrase")))) {
                httpMessage.reasonPhrase(reasonPhrase);
            }
            if (StringUtils.hasText((String)(version = headers.getAttribute("version")))) {
                httpMessage.version(version);
            }
            List cookieElements = DomUtils.getChildElementsByTagName((Element)headers, (String)"cookie");
            CookieUtils.setCookieElement(httpMessage, cookieElements);
            boolean ignoreCase = !headers.hasAttribute("ignore-case") || Boolean.parseBoolean(headers.getAttribute("ignore-case"));
            this.getHeaderValidationContext(validationContexts).ignoreCase(ignoreCase);
        }
        MessageSelectorParser.doParse((Element)element, (BeanDefinitionBuilder)builder);
        HttpMessageBuilder httpMessageBuilder = this.createMessageBuilder(httpMessage);
        DefaultMessageBuilder messageContentBuilder = this.constructMessageBuilder(body, builder);
        httpMessageBuilder.setName(messageContentBuilder.getName());
        httpMessageBuilder.setPayloadBuilder(messageContentBuilder.getPayloadBuilder());
        messageContentBuilder.getHeaderBuilders().forEach(arg_0 -> ((HttpMessageBuilder)httpMessageBuilder).addHeaderBuilder(arg_0));
        builder.addPropertyValue("messageBuilder", (Object)httpMessageBuilder);
        builder.addPropertyValue("validationContextBuilder", (Object)validationContexts);
        builder.addPropertyValue("variableExtractors", (Object)this.getVariableExtractors(element));
        return builder;
    }

    protected HttpMessageBuilder createMessageBuilder(HttpMessage httpMessage) {
        return new HttpMessageBuilder(httpMessage);
    }

    protected void validateEndpointConfiguration(Element element) {
        if (!element.hasAttribute("uri") && !element.hasAttribute("client")) {
            throw new BeanCreationException("Neither http request uri nor http client endpoint reference is given - invalid test action definition");
        }
    }
}

