/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.message;

import jakarta.servlet.http.Cookie;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.citrusframework.CitrusSettings;
import org.citrusframework.context.TestContext;
import org.citrusframework.http.message.CookieEnricher;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.Message;
import org.citrusframework.validation.builder.StaticMessageBuilder;

public class HttpMessageBuilder
extends StaticMessageBuilder {
    private final CookieEnricher cookieEnricher;

    public HttpMessageBuilder(HttpMessage message) {
        this(message, new CookieEnricher());
    }

    HttpMessageBuilder(HttpMessage message, CookieEnricher cookieEnricher) {
        super((Message)message);
        this.cookieEnricher = cookieEnricher;
    }

    public Message build(TestContext context, String messageType) {
        HttpMessage message = new HttpMessage(super.getMessage(), CitrusSettings.isHttpMessageBuilderForceCitrusHeaderUpdateEnabled());
        Message constructed = super.build(context, messageType);
        message.setName(constructed.getName());
        message.setType(constructed.getType());
        message.setPayload(constructed.getPayload());
        message.setCookies(this.constructCookies(context));
        this.replaceHeaders(constructed, (Message)message);
        return message;
    }

    private void replaceHeaders(Message from, Message to) {
        Set<String> headerKeys = to.getHeaders().keySet().stream().filter(key -> !FILTERED_HEADERS.contains(key)).collect(Collectors.toSet());
        headerKeys.forEach(to.getHeaders()::remove);
        from.getHeaders().entrySet().stream().filter(entry -> !FILTERED_HEADERS.contains(entry.getKey())).forEach(entry -> to.getHeaders().put((String)entry.getKey(), entry.getValue()));
    }

    private Cookie[] constructCookies(TestContext context) {
        List<Cookie> cookies = this.cookieEnricher.enrich(this.getMessage().getCookies(), context);
        return cookies.toArray(new Cookie[0]);
    }

    public HttpMessage getMessage() {
        return (HttpMessage)super.getMessage();
    }
}

