/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.message;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.message.Message;
import org.citrusframework.util.StringUtils;

public final class HttpMessageUtils {
    private HttpMessageUtils() {
    }

    public static void copy(Message from, HttpMessage to) {
        HttpMessage httpMessage;
        HttpMessage source = from instanceof HttpMessage ? (httpMessage = (HttpMessage)from) : new HttpMessage(from);
        HttpMessageUtils.copy(source, to);
    }

    public static void copy(HttpMessage from, HttpMessage to) {
        to.setName(from.getName());
        to.setType(from.getType());
        to.setPayload(from.getPayload());
        from.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("citrus_message_id") && !((String)entry.getKey()).equals("citrus_message_timestamp")).forEach(entry -> to.header((String)entry.getKey(), entry.getValue()));
        from.getHeaderData().forEach(to::addHeaderData);
        from.getCookies().forEach(to::cookie);
    }

    public static Map<String, List<String>> getQueryParameterMap(HttpMessage httpMessage) {
        String queryParams = (String)httpMessage.getHeader("citrus_http_query_params");
        if (StringUtils.hasText((String)queryParams)) {
            return Arrays.stream(queryParams.split(",")).map(queryParameterKeyValue -> {
                String[] keyAndValue = queryParameterKeyValue.split("=", 2);
                if (keyAndValue.length == 0) {
                    throw new IllegalArgumentException("Query parameter must have a key.");
                }
                String key = keyAndValue[0];
                String value = keyAndValue.length > 1 ? keyAndValue[1] : "";
                return Pair.of((Object)key, (Object)value);
            }).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        }
        return Collections.emptyMap();
    }
}

