/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;

public class GzipHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private final HttpServletResponse origResponse;
    private ServletOutputStream outputStream;
    private PrintWriter printWriter;

    public GzipHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
        this.origResponse = response;
    }

    public void finish() throws IOException {
        if (this.printWriter != null) {
            this.printWriter.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    public void flushBuffer() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter != null) {
            throw new IllegalStateException("Response writer already defined");
        }
        if (this.outputStream == null) {
            this.outputStream = new GzipServletOutputStream(this.origResponse);
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("Response output stream already defined");
        }
        if (this.printWriter == null) {
            this.outputStream = new GzipServletOutputStream(this.origResponse);
            this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.outputStream, this.getResponse().getCharacterEncoding()));
        }
        return this.printWriter;
    }

    public void setContentLength(int len) {
    }

    private static class GzipServletOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream byteArrayOutputStream;
        private final GZIPOutputStream gzipStream;
        private final AtomicBoolean isOpen;
        private final HttpServletResponse response;
        private final ServletOutputStream outputStream;

        public GzipServletOutputStream(HttpServletResponse response) throws IOException {
            this.response = response;
            this.isOpen = new AtomicBoolean(true);
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.outputStream = response.getOutputStream();
            this.gzipStream = new GZIPOutputStream(this.byteArrayOutputStream);
        }

        public void close() throws IOException {
            if (this.isOpen.compareAndSet(true, false)) {
                this.gzipStream.finish();
                byte[] bytes = this.byteArrayOutputStream.toByteArray();
                this.gzipStream.close();
                this.byteArrayOutputStream.close();
                this.response.setHeader("Content-Length", Integer.toString(bytes.length));
                this.response.setHeader("Content-Encoding", "gzip");
                this.outputStream.write(bytes);
                this.outputStream.flush();
                this.outputStream.close();
            }
        }

        public void flush() throws IOException {
            if (!this.isOpen.get()) {
                throw new IOException("Cannot flush a closed stream!");
            }
            this.gzipStream.flush();
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (!this.isOpen.get()) {
                throw new IOException("Stream closed!");
            }
            this.gzipStream.write(b, off, len);
        }

        public void write(int b) throws IOException {
            if (!this.isOpen.get()) {
                throw new IOException("Stream closed!");
            }
            this.gzipStream.write(b);
        }

        public boolean isReady() {
            return this.isOpen.get();
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

