/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.actions;

import jakarta.servlet.http.Cookie;
import java.util.List;
import java.util.Map;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.actions.http.HttpSendRequestMessageBuilderFactory;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.http.message.HttpMessageUtils;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.builder.SendMessageBuilderSupport;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;

public class HttpClientRequestActionBuilder
extends SendMessageAction.SendMessageActionBuilder<SendMessageAction, HttpMessageBuilderSupport, HttpClientRequestActionBuilder>
implements org.citrusframework.actions.http.HttpClientRequestActionBuilder<SendMessageAction, HttpMessageBuilderSupport, HttpClientRequestActionBuilder> {
    private final HttpMessage httpMessage;

    public HttpClientRequestActionBuilder() {
        this.httpMessage = new HttpMessage();
        this.message((MessageBuilder)new HttpMessageBuilder(this.httpMessage));
    }

    protected HttpClientRequestActionBuilder(MessageBuilder messageBuilder, HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        this.message(messageBuilder);
    }

    public HttpMessageBuilderSupport getMessageBuilderSupport() {
        if (this.messageBuilderSupport == null) {
            this.messageBuilderSupport = this.createHttpMessageBuilderSupport();
        }
        return (HttpMessageBuilderSupport)super.getMessageBuilderSupport();
    }

    protected HttpMessageBuilderSupport createHttpMessageBuilderSupport() {
        return new HttpMessageBuilderSupport(this.httpMessage, this);
    }

    public HttpClientRequestActionBuilder path(String path) {
        this.httpMessage.path(path);
        return this;
    }

    public HttpClientRequestActionBuilder method(HttpMethod method) {
        this.httpMessage.method(method);
        return this;
    }

    public HttpClientRequestActionBuilder method(String method) {
        this.method(HttpMethod.valueOf((String)method));
        return this;
    }

    public HttpClientRequestActionBuilder uri(String uri) {
        this.httpMessage.uri(uri);
        return this;
    }

    public HttpClientRequestActionBuilder queryParam(String name) {
        this.httpMessage.queryParam(name, null);
        return this;
    }

    public HttpClientRequestActionBuilder queryParam(String name, String value) {
        this.httpMessage.queryParam(name, value);
        return this;
    }

    public SendMessageAction doBuild() {
        return this.createSendMessageAction();
    }

    protected SendMessageAction createSendMessageAction() {
        return new SendMessageAction((SendMessageAction.SendMessageActionBuilder)this);
    }

    public static class HttpMessageBuilderSupport
    extends SendMessageBuilderSupport<SendMessageAction, HttpClientRequestActionBuilder, HttpMessageBuilderSupport>
    implements HttpSendRequestMessageBuilderFactory<SendMessageAction, HttpMessageBuilderSupport> {
        private final HttpMessage httpMessage;

        protected HttpMessageBuilderSupport(HttpMessage httpMessage, HttpClientRequestActionBuilder delegate) {
            super((SendMessageAction.SendMessageActionBuilder)delegate);
            this.httpMessage = httpMessage;
        }

        public HttpMessageBuilderSupport body(String payload) {
            this.httpMessage.setPayload(payload);
            return this;
        }

        public HttpMessageBuilderSupport body(MultiValueMap<String, Object> payload) {
            this.httpMessage.setPayload(payload);
            return this;
        }

        public HttpMessageBuilderSupport body(Map<String, List<Object>> payload) {
            this.body((MultiValueMap<String, Object>)MultiValueMap.fromMultiValue(payload));
            return this;
        }

        public HttpMessageBuilderSupport name(String name) {
            this.httpMessage.setName(name);
            return (HttpMessageBuilderSupport)super.name(name);
        }

        public HttpMessageBuilderSupport from(Message controlMessage) {
            HttpMessageUtils.copy(controlMessage, this.httpMessage);
            return this;
        }

        public HttpMessageBuilderSupport method(HttpMethod method) {
            ((HttpClientRequestActionBuilder)this.delegate).method(method.name());
            return this;
        }

        public HttpMessageBuilderSupport method(String method) {
            ((HttpClientRequestActionBuilder)this.delegate).method(method);
            return this;
        }

        public HttpMessageBuilderSupport uri(String uri) {
            ((HttpClientRequestActionBuilder)this.delegate).uri(uri);
            return this;
        }

        public HttpMessageBuilderSupport queryParam(String name) {
            ((HttpClientRequestActionBuilder)this.delegate).queryParam(name, null);
            return this;
        }

        public HttpMessageBuilderSupport queryParam(String name, String value) {
            ((HttpClientRequestActionBuilder)this.delegate).queryParam(name, value);
            return this;
        }

        public HttpMessageBuilderSupport version(String version) {
            this.httpMessage.version(version);
            return this;
        }

        public HttpMessageBuilderSupport contentType(String contentType) {
            this.httpMessage.contentType(contentType);
            return this;
        }

        public HttpMessageBuilderSupport accept(String accept) {
            this.httpMessage.accept(accept);
            return this;
        }

        public HttpMessageBuilderSupport cookie(Object o) {
            if (o == null) {
                return this;
            }
            if (!(o instanceof Cookie)) {
                throw new CitrusRuntimeException("Invalid cookie type: " + o.getClass());
            }
            Cookie cookie = (Cookie)o;
            this.httpMessage.cookie(cookie);
            return this;
        }

        public HttpMessageBuilderSupport cookie(Cookie cookie) {
            this.httpMessage.cookie(cookie);
            return this;
        }
    }
}

