/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.citrusframework.endpoint.AbstractPollableEndpointConfiguration;
import org.citrusframework.endpoint.resolver.DynamicEndpointUriResolver;
import org.citrusframework.endpoint.resolver.EndpointUriResolver;
import org.citrusframework.http.client.HttpResponseErrorHandler;
import org.citrusframework.http.interceptor.LoggingClientInterceptor;
import org.citrusframework.http.message.HttpMessageConverter;
import org.citrusframework.message.DefaultMessageCorrelator;
import org.citrusframework.message.ErrorHandlingStrategy;
import org.citrusframework.message.MessageCorrelator;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class HttpEndpointConfiguration
extends AbstractPollableEndpointConfiguration {
    private String requestUrl;
    private RequestMethod requestMethod = RequestMethod.POST;
    private String charset = "UTF-8";
    private String contentType = "text/plain";
    private RestTemplate restTemplate;
    private HttpClientBuilder httpClient;
    private ClientHttpRequestFactory requestFactory;
    private EndpointUriResolver endpointUriResolver = new DynamicEndpointUriResolver();
    private HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.outboundMapper();
    private HttpMessageConverter messageConverter = new HttpMessageConverter();
    private List<ClientHttpRequestInterceptor> clientInterceptors = new ArrayList<ClientHttpRequestInterceptor>();
    private ErrorHandlingStrategy errorHandlingStrategy = ErrorHandlingStrategy.PROPAGATE;
    private ResponseErrorHandler errorHandler;
    private MessageCorrelator correlator = new DefaultMessageCorrelator();
    private boolean defaultAcceptHeader = true;
    private boolean handleAttributeHeaders = false;
    private boolean handleCookies = false;
    private boolean disableRedirectHandling = false;
    private boolean removeSemicolonPathContent = true;
    private int defaultStatusCode = HttpStatus.OK.value();
    private List<MediaType> binaryMediaTypes = Arrays.asList(MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_PDF, MediaType.IMAGE_GIF, MediaType.IMAGE_JPEG, MediaType.IMAGE_PNG, MediaType.valueOf((String)"application/zip"));

    public HttpEndpointConfiguration() {
        this.clientInterceptors.add(new LoggingClientInterceptor());
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String url) {
        this.requestUrl = url;
    }

    public void setEndpointUriResolver(EndpointUriResolver endpointUriResolver) {
        this.endpointUriResolver = endpointUriResolver;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.clientInterceptors.addAll(restTemplate.getInterceptors());
        restTemplate.setInterceptors(this.clientInterceptors);
        this.restTemplate = restTemplate;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ErrorHandlingStrategy getErrorHandlingStrategy() {
        return this.errorHandlingStrategy;
    }

    public void setErrorHandlingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getContentType() {
        return this.contentType;
    }

    public RestTemplate getRestTemplate() {
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplate();
            this.restTemplate.setInterceptors(this.clientInterceptors);
        }
        this.restTemplate.setRequestFactory(this.getRequestFactory());
        this.restTemplate.setErrorHandler(this.getErrorHandler());
        if (!this.defaultAcceptHeader) {
            this.restTemplate.getMessageConverters().stream().filter(StringHttpMessageConverter.class::isInstance).map(StringHttpMessageConverter.class::cast).forEach(converter -> converter.setWriteAcceptCharset(this.defaultAcceptHeader));
        }
        return this.restTemplate;
    }

    public EndpointUriResolver getEndpointUriResolver() {
        return this.endpointUriResolver;
    }

    public HeaderMapper<HttpHeaders> getHeaderMapper() {
        return this.headerMapper;
    }

    public List<ClientHttpRequestInterceptor> getClientInterceptors() {
        return this.clientInterceptors;
    }

    public void setClientInterceptors(List<ClientHttpRequestInterceptor> clientInterceptors) {
        this.clientInterceptors = clientInterceptors;
        this.getRestTemplate().setInterceptors(clientInterceptors);
    }

    public void setCorrelator(MessageCorrelator correlator) {
        this.correlator = correlator;
    }

    public MessageCorrelator getCorrelator() {
        return this.correlator;
    }

    public ClientHttpRequestFactory getRequestFactory() {
        if (this.requestFactory == null) {
            this.requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)this.getHttpClient().build());
        }
        return this.requestFactory;
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public HttpClientBuilder getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = HttpClientBuilder.create().useSystemProperties();
        }
        if (this.disableRedirectHandling) {
            this.httpClient.disableRedirectHandling();
        }
        return this.httpClient;
    }

    public void setHttpClient(HttpClientBuilder httpClient) {
        this.httpClient = httpClient;
    }

    public HttpMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(HttpMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setDefaultAcceptHeader(boolean defaultAcceptHeader) {
        this.defaultAcceptHeader = defaultAcceptHeader;
    }

    public boolean isDefaultAcceptHeader() {
        return this.defaultAcceptHeader;
    }

    public boolean isHandleAttributeHeaders() {
        return this.handleAttributeHeaders;
    }

    public void setHandleAttributeHeaders(boolean handleAttributeHeaders) {
        this.handleAttributeHeaders = handleAttributeHeaders;
    }

    public boolean isHandleCookies() {
        return this.handleCookies;
    }

    public void setHandleCookies(boolean handleCookies) {
        this.handleCookies = handleCookies;
    }

    public boolean isDisableRedirectHandling() {
        return this.disableRedirectHandling;
    }

    public void setDisableRedirectHandling(boolean disableRedirectHandling) {
        this.disableRedirectHandling = disableRedirectHandling;
    }

    public boolean isRemoveSemicolonPathContent() {
        return this.removeSemicolonPathContent;
    }

    public void setRemoveSemicolonPathContent(boolean removeSemicolonPathContent) {
        this.removeSemicolonPathContent = removeSemicolonPathContent;
    }

    public ResponseErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            this.errorHandler = new HttpResponseErrorHandler(this.errorHandlingStrategy);
        }
        return this.errorHandler;
    }

    public void setErrorHandler(ResponseErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public int getDefaultStatusCode() {
        return this.defaultStatusCode;
    }

    public void setDefaultStatusCode(int defaultStatusCode) {
        this.defaultStatusCode = defaultStatusCode;
    }

    public List<MediaType> getBinaryMediaTypes() {
        return this.binaryMediaTypes;
    }

    public void setBinaryMediaTypes(List<MediaType> binaryMediaTypes) {
        this.binaryMediaTypes = binaryMediaTypes;
    }
}

