/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.servlet;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import org.citrusframework.CitrusSettings;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.CachingInputStream;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;

public class CachingHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(CachingHttpServletRequestWrapper.class);
    private CachingInputStream bodyStream;

    public CachingHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> params = new HashMap<String, String[]>(super.getParameterMap());
        MediaType contentType = Optional.ofNullable(this.getContentType()).map(mediaType -> {
            try {
                return MediaType.valueOf((String)mediaType);
            }
            catch (InvalidMediaTypeException e) {
                logger.warn(String.format("Failed to parse content type '%s' - using default media type '%s'", this.getContentType(), "*/*"), (Throwable)e);
                return MediaType.ALL;
            }
        }).orElse(MediaType.ALL);
        Charset charset = Optional.ofNullable(contentType.getCharset()).orElse(Charset.forName(CitrusSettings.CITRUS_FILE_ENCODING));
        if (RequestMethod.POST.name().equals(this.getMethod()) || RequestMethod.PUT.name().equals(this.getMethod())) {
            if (new MediaType(contentType.getType(), contentType.getSubtype()).equals((Object)MediaType.APPLICATION_FORM_URLENCODED)) {
                try {
                    this.fillParams(params, new String(FileUtils.copyToByteArray((InputStream)this.getInputStream()), charset), charset);
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to read request body", (Throwable)e);
                }
            }
        } else {
            this.fillParams(params, this.getQueryString(), charset);
        }
        return params;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.bodyStream == null) {
            this.bodyStream = super.getInputStream() != null ? new CachingInputStream((InputStream)super.getInputStream()) : new CachingInputStream((InputStream)new ByteArrayInputStream(new byte[0]));
        }
        return new RequestCachingInputStream(this.bodyStream.get());
    }

    private void fillParams(Map<String, String[]> params, String queryString, Charset charset) {
        if (StringUtils.hasText((String)queryString)) {
            StringTokenizer tokenizer = new StringTokenizer(queryString, "&");
            while (tokenizer.hasMoreTokens()) {
                String[] nameValuePair = tokenizer.nextToken().split("=");
                String paramName = nameValuePair[0];
                if (params.containsKey(paramName)) continue;
                String paramValue = nameValuePair.length > 1 ? nameValuePair[1] : "";
                params.put(URLDecoder.decode(paramName, charset), new String[]{URLDecoder.decode(paramValue, charset)});
            }
        }
    }

    private static final class RequestCachingInputStream
    extends ServletInputStream {
        private final InputStream delegate;

        private RequestCachingInputStream(InputStream is) {
            this.delegate = is;
        }

        public boolean isFinished() {
            try {
                return this.delegate.available() == 0;
            }
            catch (IOException e) {
                return true;
            }
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new CitrusRuntimeException("Unsupported operation");
        }

        public int read() throws IOException {
            return this.delegate.read();
        }
    }
}

