/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.dsl.builder;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.util.Map;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.CitrusSettings;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.dsl.JsonPathSupport;
import org.citrusframework.dsl.MessageSupport;
import org.citrusframework.dsl.XpathSupport;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.message.MessageHeaderDataBuilder;
import org.citrusframework.message.MessagePayloadBuilder;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.message.MessageType;
import org.citrusframework.message.builder.MarshallingHeaderDataBuilder;
import org.citrusframework.message.builder.MarshallingPayloadBuilder;
import org.citrusframework.message.builder.ObjectMappingHeaderDataBuilder;
import org.citrusframework.message.builder.ObjectMappingPayloadBuilder;
import org.citrusframework.message.builder.SendMessageBuilderSupport;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.util.FileUtils;
import org.citrusframework.validation.interceptor.BinaryMessageProcessor;
import org.citrusframework.validation.interceptor.GzipMessageProcessor;
import org.citrusframework.validation.json.JsonPathMessageProcessor;
import org.citrusframework.validation.json.JsonPathMessageValidationContext;
import org.citrusframework.validation.xml.XpathMessageProcessor;
import org.citrusframework.variable.VariableExtractor;
import org.citrusframework.variable.dictionary.DataDictionary;
import org.citrusframework.xml.MarshallerAdapter;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Marshaller;

public class SendMessageActionBuilder<B extends SendMessageActionBuilder<B>>
extends AbstractTestActionBuilder<SendMessageAction, B> {
    protected final B self;
    private final SendMessageAction.SendMessageActionBuilder<?, ?, ?> delegate;
    private String messageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
    private final GzipMessageProcessor gzipMessageProcessor = new GzipMessageProcessor();
    private final BinaryMessageProcessor binaryMessageProcessor = new BinaryMessageProcessor();
    private XpathMessageProcessor xpathMessageProcessor;
    private JsonPathMessageProcessor jsonPathMessageProcessor;

    public SendMessageActionBuilder() {
        this((SendMessageAction.SendMessageActionBuilder<?, ?, ?>)new SendMessageAction.Builder());
    }

    public SendMessageActionBuilder(SendMessageAction.SendMessageActionBuilder<?, ?, ?> builder) {
        this.self = this;
        this.delegate = builder;
    }

    public B endpoint(Endpoint messageEndpoint) {
        this.delegate.endpoint(messageEndpoint);
        return this.self;
    }

    public B endpoint(String messageEndpointUri) {
        this.delegate.endpoint(messageEndpointUri);
        return this.self;
    }

    public B fork(boolean forkMode) {
        this.delegate.fork(forkMode);
        return this.self;
    }

    public B messageBuilder(MessageBuilder messageBuilder) {
        this.delegate.message(messageBuilder);
        return this.self;
    }

    public B message(Message message) {
        this.delegate.message(message);
        return this.self;
    }

    public B messageName(String name) {
        ((SendMessageBuilderSupport)this.delegate.message()).name(name);
        return this.self;
    }

    public B payload(String payload) {
        ((SendMessageBuilderSupport)this.delegate.message()).body(payload);
        return this.self;
    }

    public B payload(Resource payloadResource) {
        return this.payload(payloadResource, FileUtils.getDefaultCharset());
    }

    public B payload(Resource payloadResource, Charset charset) {
        ((SendMessageBuilderSupport)this.delegate.message()).body(payloadResource, charset);
        return this.self;
    }

    public B payload(Object payload, Marshaller marshaller) {
        ((SendMessageBuilderSupport)this.delegate.message()).body((MessagePayloadBuilder)new MarshallingPayloadBuilder(payload, (org.citrusframework.xml.Marshaller)new MarshallerAdapter(marshaller)));
        return this.self;
    }

    public B payload(Object payload, ObjectMapper objectMapper) {
        ((SendMessageBuilderSupport)this.delegate.message()).body((MessagePayloadBuilder)new ObjectMappingPayloadBuilder(payload, objectMapper));
        return this.self;
    }

    public B payloadModel(Object payload) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            ((SendMessageBuilderSupport)this.delegate.message()).body((MessagePayloadBuilder)new ObjectMappingPayloadBuilder(payload));
        } else {
            ((SendMessageBuilderSupport)this.delegate.message()).body((MessagePayloadBuilder)new MarshallingPayloadBuilder(payload));
        }
        return this.self;
    }

    public B payload(Object payload, String mapperOrMarshallerName) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            ((SendMessageBuilderSupport)this.delegate.message()).body((MessagePayloadBuilder)new ObjectMappingPayloadBuilder(payload, mapperOrMarshallerName));
        } else {
            ((SendMessageBuilderSupport)this.delegate.message()).body((MessagePayloadBuilder)new MarshallingPayloadBuilder(payload, mapperOrMarshallerName));
        }
        return this.self;
    }

    public B header(String name, Object value) {
        ((SendMessageBuilderSupport)this.delegate.message()).header(name, value);
        return this.self;
    }

    public B headers(Map<String, Object> headers) {
        ((SendMessageBuilderSupport)this.delegate.message()).headers(headers);
        return this.self;
    }

    public B header(String data) {
        ((SendMessageBuilderSupport)this.delegate.message()).header(data);
        return this.self;
    }

    public B header(Resource resource) {
        return this.header(resource, FileUtils.getDefaultCharset());
    }

    public B header(Resource resource, Charset charset) {
        ((SendMessageBuilderSupport)this.delegate.message()).header(resource, charset);
        return this.self;
    }

    public B headerFragment(Object model, Marshaller marshaller) {
        ((SendMessageBuilderSupport)this.delegate.message()).header((MessageHeaderDataBuilder)new MarshallingHeaderDataBuilder(model, (org.citrusframework.xml.Marshaller)new MarshallerAdapter(marshaller)));
        return this.self;
    }

    public B headerFragment(Object model, ObjectMapper objectMapper) {
        ((SendMessageBuilderSupport)this.delegate.message()).header((MessageHeaderDataBuilder)new ObjectMappingHeaderDataBuilder(model, objectMapper));
        return this.self;
    }

    public B headerFragment(Object model) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            ((SendMessageBuilderSupport)this.delegate.message()).header((MessageHeaderDataBuilder)new ObjectMappingHeaderDataBuilder(model));
        } else {
            ((SendMessageBuilderSupport)this.delegate.message()).header((MessageHeaderDataBuilder)new MarshallingHeaderDataBuilder(model));
        }
        return this.self;
    }

    public B headerFragment(Object model, String mapperOrMarshallerName) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            ((SendMessageBuilderSupport)this.delegate.message()).header((MessageHeaderDataBuilder)new ObjectMappingHeaderDataBuilder(model, mapperOrMarshallerName));
        } else {
            ((SendMessageBuilderSupport)this.delegate.message()).header((MessageHeaderDataBuilder)new MarshallingHeaderDataBuilder(model, mapperOrMarshallerName));
        }
        return this.self;
    }

    public B messageType(MessageType messageType) {
        this.messageType(messageType.name());
        return this.self;
    }

    public B messageType(String messageType) {
        this.messageType = messageType;
        ((SendMessageBuilderSupport)this.delegate.message()).type(messageType);
        if (MessageType.BINARY.name().equalsIgnoreCase(messageType)) {
            this.delegate.process((MessageProcessor)this.binaryMessageProcessor);
        }
        if (MessageType.GZIP.name().equalsIgnoreCase(messageType)) {
            this.delegate.process((MessageProcessor)this.gzipMessageProcessor);
        }
        return this.self;
    }

    public B extractFromHeader(String headerName, String variable) {
        this.variableExtractor((VariableExtractor)new MessageSupport().headers().expression(headerName, (Object)variable).build());
        return this.self;
    }

    public B extractFromPayload(String path, String variable) {
        if (JsonPathMessageValidationContext.isJsonPathExpression((String)path)) {
            this.variableExtractor(new JsonPathSupport().expression(path, (Object)variable).asExtractor());
        } else {
            this.variableExtractor(new XpathSupport().expression(path, (Object)variable).asExtractor());
        }
        return this.self;
    }

    public B variableExtractor(VariableExtractor extractor) {
        this.delegate.process((MessageProcessor)extractor);
        return this.self;
    }

    public B xpath(String expression, String value) {
        if (this.xpathMessageProcessor == null) {
            this.xpathMessageProcessor = new XpathMessageProcessor();
            this.delegate.process((MessageProcessor)this.xpathMessageProcessor);
        }
        this.xpathMessageProcessor.getXPathExpressions().put(expression, value);
        return this.self;
    }

    public B jsonPath(String expression, String value) {
        if (this.jsonPathMessageProcessor == null) {
            this.jsonPathMessageProcessor = new JsonPathMessageProcessor();
            this.delegate.process((MessageProcessor)this.jsonPathMessageProcessor);
        }
        this.jsonPathMessageProcessor.getJsonPathExpressions().put(expression, value);
        return this.self;
    }

    public B withReferenceResolver(ReferenceResolver referenceResolver) {
        this.delegate.withReferenceResolver(referenceResolver);
        return this.self;
    }

    public B dictionary(DataDictionary<?> dictionary) {
        ((SendMessageBuilderSupport)this.delegate.message()).dictionary(dictionary);
        return this.self;
    }

    public B dictionary(String dictionaryName) {
        ((SendMessageBuilderSupport)this.delegate.message()).dictionary(dictionaryName);
        return this.self;
    }

    public SendMessageAction build() {
        return this.delegate.build();
    }
}

