/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.dsl.builder;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.dsl.JsonPathSupport;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.validation.MessageValidator;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.json.JsonPathMessageValidationContext;
import org.citrusframework.variable.VariableExtractor;
import org.citrusframework.zookeeper.actions.ZooExecuteAction;
import org.citrusframework.zookeeper.client.ZooClient;
import org.citrusframework.zookeeper.command.CommandResultCallback;
import org.citrusframework.zookeeper.command.ZooCommand;
import org.citrusframework.zookeeper.command.ZooResponse;

public class ZooExecuteActionBuilder
extends AbstractTestActionBuilder<ZooExecuteAction, ZooExecuteActionBuilder> {
    private final ZooExecuteAction.Builder delegate = new ZooExecuteAction.Builder();

    public ZooExecuteActionBuilder client(ZooClient zooClient) {
        this.delegate.client(zooClient);
        return this;
    }

    public ZooExecuteActionBuilder command(ZooCommand<?> command) {
        this.delegate.command(command);
        return this;
    }

    public ZooExecuteActionBuilder create(String path, String data) {
        this.delegate.create(path, data);
        return this;
    }

    public ZooExecuteActionBuilder mode(String mode) {
        this.delegate.mode(mode);
        return this;
    }

    public ZooExecuteActionBuilder acl(String acl) {
        this.delegate.acl(acl);
        return this;
    }

    public ZooExecuteActionBuilder delete(String path) {
        this.delegate.delete(path);
        return this;
    }

    public ZooExecuteActionBuilder version(int version) {
        this.delegate.version(version);
        return this;
    }

    public ZooExecuteActionBuilder exists(String path) {
        this.delegate.exists(path);
        return this;
    }

    public ZooExecuteActionBuilder children(String path) {
        this.delegate.children(path);
        return this;
    }

    public ZooExecuteActionBuilder get(String path) {
        this.delegate.get(path);
        return this;
    }

    public ZooExecuteActionBuilder info() {
        this.delegate.info();
        return this;
    }

    public ZooExecuteActionBuilder set(String path, String data) {
        this.delegate.set(path, data);
        return this;
    }

    public ZooExecuteActionBuilder validateCommandResult(CommandResultCallback<ZooResponse> callback) {
        this.delegate.validateCommandResult(callback);
        return this;
    }

    public ZooExecuteActionBuilder result(String result) {
        this.delegate.result(result);
        return this;
    }

    public ZooExecuteActionBuilder mapper(ObjectMapper jsonMapper) {
        this.delegate.mapper(jsonMapper);
        return this;
    }

    public ZooExecuteActionBuilder validator(MessageValidator<? extends ValidationContext> validator) {
        this.delegate.validator(validator);
        return this;
    }

    public ZooExecuteActionBuilder pathExpressionValidator(MessageValidator<? extends ValidationContext> validator) {
        this.delegate.pathExpressionValidator(validator);
        return this;
    }

    public ZooExecuteActionBuilder extract(String jsonPath, String variableName) {
        return this.extractor(new JsonPathSupport().expression(jsonPath, (Object)variableName).asExtractor());
    }

    public ZooExecuteActionBuilder extractor(VariableExtractor variableExtractor) {
        this.delegate.extract(variableExtractor);
        return this;
    }

    public ZooExecuteActionBuilder extractor(VariableExtractor.Builder<?, ?> builder) {
        return this.extractor(builder.build());
    }

    public ZooExecuteActionBuilder validate(String jsonPath, String expectedValue) {
        this.delegate.validate(jsonPath, expectedValue);
        return this;
    }

    public ZooExecuteActionBuilder validationContext(JsonPathMessageValidationContext validationContext) {
        this.delegate.validationContext(validationContext);
        return this;
    }

    public ZooExecuteActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.delegate.withReferenceResolver(referenceResolver);
        return this;
    }

    public ZooExecuteAction build() {
        return this.delegate.build();
    }
}

