/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.dsl.junit.jupiter;

import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.citrusframework.TestAction;
import org.citrusframework.TestCase;
import org.citrusframework.TestResult;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.annotations.CitrusTest;
import org.citrusframework.annotations.CitrusTestSource;
import org.citrusframework.annotations.CitrusXmlTest;
import org.citrusframework.context.TestContext;
import org.citrusframework.dsl.annotations.CitrusDslAnnotations;
import org.citrusframework.dsl.design.DefaultTestDesigner;
import org.citrusframework.dsl.design.TestDesigner;
import org.citrusframework.dsl.runner.DefaultTestRunner;
import org.citrusframework.dsl.runner.TestRunner;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.TestCaseFailedException;
import org.citrusframework.junit.jupiter.CitrusBaseExtension;
import org.citrusframework.junit.jupiter.CitrusExtensionHelper;
import org.citrusframework.junit.jupiter.spring.CitrusSpringXmlTestFactory;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CitrusExtension
extends CitrusBaseExtension
implements ParameterResolver,
BeforeEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
TestExecutionExceptionHandler {
    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        if (!CitrusExtension.isSpringXmlTestMethod(extensionContext.getRequiredTestMethod()) && (CitrusExtension.isRunnerMethod(extensionContext.getRequiredTestMethod()) || CitrusExtension.isRunnerClass(extensionContext.getRequiredTestClass()))) {
            TestCase testCase = CitrusExtension.getTestCase(extensionContext);
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)throwable));
        }
        throw throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        if (!CitrusExtension.isSpringXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            TestCase testCase = CitrusExtension.getTestCase(extensionContext);
            extensionContext.getExecutionException().ifPresent(e -> testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e)));
            if (CitrusExtension.isDesignerMethod(extensionContext.getRequiredTestMethod()) || CitrusExtension.isDesignerClass(extensionContext.getRequiredTestClass())) {
                TestContext context = CitrusExtensionHelper.getTestContext((ExtensionContext)extensionContext);
                try {
                    CitrusExtensionHelper.getCitrus((ExtensionContext)extensionContext).run((TestAction)testCase, context);
                }
                finally {
                    testCase.finish(context);
                }
            } else if (CitrusExtension.isRunnerMethod(extensionContext.getRequiredTestMethod()) || CitrusExtension.isRunnerClass(extensionContext.getRequiredTestClass())) {
                CitrusExtension.getTestRunner(extensionContext).stop();
            }
            extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusExtensionHelper.getBaseKey((ExtensionContext)extensionContext) + TestRunner.class.getSimpleName()));
            extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusExtensionHelper.getBaseKey((ExtensionContext)extensionContext) + TestDesigner.class.getSimpleName()));
        }
        extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusExtensionHelper.getBaseKey((ExtensionContext)extensionContext) + TestContext.class.getSimpleName()));
        extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusExtensionHelper.getBaseKey((ExtensionContext)extensionContext) + TestCase.class.getSimpleName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        if (CitrusExtension.isSpringXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            TestCase testCase = CitrusExtension.getXmlTestCase(extensionContext);
            TestContext context = CitrusExtensionHelper.getTestContext((ExtensionContext)extensionContext);
            try {
                CitrusExtensionHelper.getCitrus((ExtensionContext)extensionContext).run((TestAction)testCase, context);
            }
            finally {
                testCase.finish(context);
            }
        } else {
            CitrusDslAnnotations.injectTestDesigner(extensionContext.getRequiredTestInstance(), CitrusExtension.getTestDesigner(extensionContext));
            CitrusDslAnnotations.injectTestRunner(extensionContext.getRequiredTestInstance(), CitrusExtension.getTestRunner(extensionContext));
            CitrusAnnotations.injectTestContext((Object)extensionContext.getRequiredTestInstance(), (TestContext)CitrusExtensionHelper.getTestContext((ExtensionContext)extensionContext));
            CitrusAnnotations.injectEndpoints((Object)extensionContext.getRequiredTestInstance(), (TestContext)CitrusExtensionHelper.getTestContext((ExtensionContext)extensionContext));
        }
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        CitrusExtensionHelper.getTestContext((ExtensionContext)extensionContext);
        if (CitrusExtension.isSpringXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            CitrusExtension.getXmlTestCase(extensionContext);
        } else {
            TestCase testCase = CitrusExtension.getTestCase(extensionContext);
            if (CitrusExtension.isRunnerMethod(extensionContext.getRequiredTestMethod()) || CitrusExtension.isRunnerClass(extensionContext.getRequiredTestClass())) {
                TestRunner testRunner = CitrusExtension.getTestRunner(extensionContext);
                try {
                    testRunner.start();
                }
                catch (AssertionError | Exception e) {
                    CitrusExtension.getTestCase(extensionContext).setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
                    throw new TestCaseFailedException((Throwable)e);
                }
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().isAnnotationPresent(CitrusResource.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (TestDesigner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return CitrusExtension.getTestDesigner(extensionContext);
        }
        if (TestRunner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return CitrusExtension.getTestRunner(extensionContext);
        }
        return CitrusExtensionHelper.resolveParameter((ParameterContext)parameterContext, (ExtensionContext)extensionContext);
    }

    protected static TestDesigner getTestDesigner(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestDesigner)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey((ExtensionContext)extensionContext) + TestDesigner.class.getSimpleName()), key -> {
            CitrusTest citrusTestAnnotation;
            Object testName = extensionContext.getRequiredTestClass().getSimpleName() + "." + extensionContext.getRequiredTestMethod().getName();
            if (extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class) != null && StringUtils.hasText((String)(citrusTestAnnotation = extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class)).name())) {
                testName = citrusTestAnnotation.name();
            }
            DefaultTestDesigner testDesigner = new DefaultTestDesigner(CitrusExtensionHelper.getTestContext((ExtensionContext)extensionContext));
            testDesigner.testClass(extensionContext.getRequiredTestClass());
            testDesigner.name((String)testName);
            testDesigner.packageName(extensionContext.getRequiredTestClass().getPackage().getName());
            return testDesigner;
        }, TestDesigner.class);
    }

    protected static TestRunner getTestRunner(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestRunner)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey((ExtensionContext)extensionContext) + TestRunner.class.getSimpleName()), key -> {
            CitrusTest citrusTestAnnotation;
            Object testName = extensionContext.getRequiredTestClass().getSimpleName() + "." + extensionContext.getRequiredTestMethod().getName();
            if (extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class) != null && StringUtils.hasText((String)(citrusTestAnnotation = extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class)).name())) {
                testName = citrusTestAnnotation.name();
            }
            DefaultTestRunner testRunner = new DefaultTestRunner(CitrusExtensionHelper.getTestContext((ExtensionContext)extensionContext));
            testRunner.testClass(extensionContext.getRequiredTestClass());
            testRunner.name((String)testName);
            testRunner.packageName(extensionContext.getRequiredTestClass().getPackage().getName());
            return testRunner;
        }, TestRunner.class);
    }

    protected static TestCase getTestCase(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCase)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey((ExtensionContext)extensionContext) + TestCase.class.getSimpleName()), key -> {
            if (CitrusExtension.isDesignerMethod(extensionContext.getRequiredTestMethod())) {
                return CitrusExtension.getTestDesigner(extensionContext).getTestCase();
            }
            if (CitrusExtension.isRunnerMethod(extensionContext.getRequiredTestMethod())) {
                return CitrusExtension.getTestRunner(extensionContext).getTestCase();
            }
            if (CitrusExtension.isSpringXmlTestMethod(extensionContext.getRequiredTestMethod())) {
                return CitrusExtension.getXmlTestCase(extensionContext);
            }
            if (CitrusExtension.isDesignerClass(extensionContext.getRequiredTestClass())) {
                return CitrusExtension.getTestDesigner(extensionContext).getTestCase();
            }
            if (Stream.of(extensionContext.getRequiredTestClass().getDeclaredFields()).anyMatch(field -> TestRunner.class.isAssignableFrom(field.getType()))) {
                return CitrusExtension.getTestRunner(extensionContext).getTestCase();
            }
            throw new CitrusRuntimeException("Neither test class nor test method is using any of test runner, designer or Xml test file.");
        }, TestCase.class);
    }

    private static boolean isDesignerMethod(Method method) {
        Class<?>[] parameterTypes;
        for (Class<TestDesigner> clazz : parameterTypes = method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(TestDesigner.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDesignerClass(Class<?> type) {
        return Stream.of(type.getDeclaredFields()).anyMatch(field -> TestDesigner.class.isAssignableFrom(field.getType()));
    }

    private static boolean isRunnerMethod(Method method) {
        Class<?>[] parameterTypes;
        for (Class<TestRunner> clazz : parameterTypes = method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(TestRunner.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRunnerClass(Class<?> type) {
        return Stream.of(type.getDeclaredFields()).anyMatch(field -> TestRunner.class.isAssignableFrom(field.getType()));
    }

    public static TestCase getXmlTestCase(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCase)extensionContext.getRoot().getStore(org.citrusframework.junit.jupiter.CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey((ExtensionContext)extensionContext) + TestCase.class.getSimpleName()), key -> CitrusExtensionHelper.createTestLoader((ExtensionContext)extensionContext).getTestCase(), TestCase.class);
    }

    private static boolean isSpringXmlTestMethod(Method method) {
        return method.isAnnotationPresent(CitrusXmlTest.class) || method.isAnnotationPresent(CitrusSpringXmlTestFactory.class) || method.isAnnotationPresent(CitrusTestSource.class) && method.getAnnotation(CitrusTestSource.class).type().equals("spring");
    }
}

