/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.testng;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusContext;
import org.citrusframework.CitrusContextProvider;
import org.citrusframework.CitrusSpringContext;
import org.citrusframework.CitrusSpringContextProvider;
import org.citrusframework.TestCase;
import org.citrusframework.TestGroupAware;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.annotations.CitrusXmlTest;
import org.citrusframework.common.TestLoader;
import org.citrusframework.config.CitrusSpringConfig;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.testng.TestNGCitrusMethodInterceptor;
import org.citrusframework.testng.TestNGHelper;
import org.citrusframework.testng.TestNGParameterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.testng.IHookCallBack;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@ContextConfiguration(classes={CitrusSpringConfig.class})
@Listeners(value={TestNGCitrusMethodInterceptor.class})
@Deprecated
public abstract class AbstractTestNGCitrusTest
extends AbstractTestNGSpringContextTests {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Citrus citrus;
    private TestCase testCase;

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (method != null && method.getAnnotation(CitrusXmlTest.class) != null) {
            List methodTestLoaders = TestNGHelper.createMethodTestLoaders((Method)method, this::createTestLoader);
            if (!CollectionUtils.isEmpty((Collection)methodTestLoaders)) {
                try {
                    this.run(testResult, method, (TestLoader)methodTestLoaders.get(testResult.getMethod().getCurrentInvocationCount() % methodTestLoaders.size()), testResult.getMethod().getCurrentInvocationCount());
                    testResult.setStatus(1);
                }
                catch (Exception e) {
                    testResult.setThrowable((Throwable)e);
                    testResult.setStatus(2);
                }
            }
            super.run((IHookCallBack)new TestNGHelper.FakeExecutionCallBack(callBack.getParameters()), testResult);
            if (testResult.getThrowable() != null) {
                if (testResult.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)testResult.getThrowable();
                }
                throw new CitrusRuntimeException(testResult.getThrowable());
            }
        } else {
            super.run(callBack, testResult);
        }
    }

    protected void run(ITestResult testResult, Method method, TestLoader testLoader, int invocationCount) {
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(this.applicationContext));
        }
        TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
        CitrusAnnotations.injectAll((Object)testLoader, (Citrus)this.citrus, (TestContext)ctx);
        testLoader.configureTestCase(t -> {
            if (t instanceof TestGroupAware) {
                ((TestGroupAware)t).setGroups(testResult.getMethod().getGroups());
            }
        });
        testLoader.doWithTestCase(t -> ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this), (Object[])this.resolveParameter(testResult, method, (TestCase)t, ctx, invocationCount)));
        testLoader.load();
    }

    protected Object[] resolveParameter(ITestResult testResult, Method method, TestCase testCase, TestContext context, int invocationCount) {
        Object[] dataProviderParams = null;
        if (method.getAnnotation(Test.class) != null && StringUtils.hasText((String)method.getAnnotation(Test.class).dataProvider())) {
            Method[] dataProvider = new Method[1];
            ReflectionUtils.doWithMethods(method.getDeclaringClass(), current -> {
                if (StringUtils.hasText((String)current.getAnnotation(DataProvider.class).name()) && current.getAnnotation(DataProvider.class).name().equals(method.getAnnotation(Test.class).dataProvider())) {
                    dataProvider[0] = current;
                } else if (current.getName().equals(method.getAnnotation(Test.class).dataProvider())) {
                    dataProvider[0] = current;
                }
            }, toFilter -> toFilter.getAnnotation(DataProvider.class) != null);
            if (dataProvider[0] == null) {
                throw new CitrusRuntimeException("Unable to find data provider: " + method.getAnnotation(Test.class).dataProvider());
            }
            Object[][] parameters = (Object[][])ReflectionUtils.invokeMethod((Method)dataProvider[0], (Object)((Object)this), (Object[])this.resolveParameter(testResult, dataProvider[0], testCase, context, -1));
            if (parameters != null) {
                dataProviderParams = parameters[invocationCount % parameters.length];
                TestNGParameterHelper.injectTestParameters((Method)method, (TestCase)testCase, (Object[])dataProviderParams);
            }
        }
        Object[] values = new Object[method.getParameterTypes().length];
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] parameterAnnotations = method.getParameterAnnotations()[i];
            Class<?> parameterType = parameterTypes[i];
            for (Annotation annotation : parameterAnnotations) {
                if (!(annotation instanceof CitrusResource)) continue;
                values[i] = this.resolveAnnotatedResource(testResult, parameterType, context);
            }
            if (parameterType.equals(ITestResult.class)) {
                values[i] = testResult;
                continue;
            }
            if (parameterType.equals(ITestContext.class)) {
                values[i] = testResult.getTestContext();
                continue;
            }
            if (values[i] != null || dataProviderParams == null || i >= dataProviderParams.length) continue;
            values[i] = dataProviderParams[i];
        }
        return values;
    }

    protected Object resolveAnnotatedResource(ITestResult testResult, Class<?> parameterType, TestContext context) {
        if (TestContext.class.isAssignableFrom(parameterType)) {
            return context;
        }
        throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + parameterType);
    }

    @BeforeSuite(alwaysRun=true)
    public void beforeSuite(ITestContext testContext) throws Exception {
        this.springTestContextPrepareTestInstance();
        Assert.notNull((Object)this.applicationContext, (String)"Missing proper application context in before suite initialization");
        this.citrus = Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(this.applicationContext));
        this.citrus.beforeSuite(testContext.getSuite().getName(), testContext.getIncludedGroups());
    }

    @AfterSuite(alwaysRun=true)
    public void afterSuite(ITestContext testContext) {
        if (this.citrus != null) {
            this.citrus.afterSuite(testContext.getSuite().getName(), testContext.getIncludedGroups());
        }
    }

    protected TestContext prepareTestContext(TestContext testContext) {
        return testContext;
    }

    protected TestLoader createTestLoader(String testName, String packageName, String type) {
        TestLoader testLoader = (TestLoader)TestLoader.lookup((String)type).orElseThrow(() -> new CitrusRuntimeException("Missing Spring XML test loader in project classpath - please add citrus-spring module to the project"));
        testLoader.setTestClass(((Object)((Object)this)).getClass());
        testLoader.setTestName(testName);
        testLoader.setPackageName(packageName);
        CitrusAnnotations.injectCitrusContext((Object)testLoader, (CitrusContext)Optional.ofNullable(this.citrus).map(Citrus::getCitrusContext).orElseGet(() -> CitrusSpringContext.create((ApplicationContext)this.applicationContext)));
        testLoader.configureTestCase(t -> {
            this.testCase = t;
        });
        return testLoader;
    }

    protected TestCase getTestCase() {
        return this.testCase;
    }
}

