/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.junit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.CitrusSettings;
import org.citrusframework.DefaultTestCase;
import org.citrusframework.DefaultTestCaseRunner;
import org.citrusframework.TestCase;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.junit.CitrusFrameworkMethod;
import org.citrusframework.junit.JUnit4ParameterHelper;
import org.citrusframework.util.FileUtils;
import org.junit.runners.model.FrameworkMethod;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public final class JUnit4Helper {
    public static final String BUILDER_ATTRIBUTE = "builder";

    private JUnit4Helper() {
    }

    public static void invokeTestMethod(Object target, CitrusFrameworkMethod frameworkMethod, TestContext context) {
        Object[] params = JUnit4ParameterHelper.resolveParameter(frameworkMethod, context);
        ReflectionUtils.invokeMethod((Method)frameworkMethod.getMethod(), (Object)target, (Object[])params);
    }

    public static TestCaseRunner createTestRunner(CitrusFrameworkMethod frameworkMethod, Class<?> testClass, TestContext context) {
        DefaultTestCaseRunner testCaseRunner = new DefaultTestCaseRunner((TestCase)new DefaultTestCase(), context);
        testCaseRunner.testClass(testClass);
        testCaseRunner.name(frameworkMethod.getTestName());
        testCaseRunner.packageName(frameworkMethod.getPackageName());
        return testCaseRunner;
    }

    public static List<FrameworkMethod> findInterceptedMethods(FrameworkMethod method, String type, String[] testNames, String testPackageName, String[] packagesToScan, String[] sources) {
        ArrayList<FrameworkMethod> interceptedMethods = new ArrayList<FrameworkMethod>();
        String packageName = method.getMethod().getDeclaringClass().getPackage().getName();
        if (StringUtils.hasText((String)testPackageName)) {
            packageName = testPackageName;
        }
        if (testNames.length > 0) {
            for (String name : testNames) {
                interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), type, name, packageName));
            }
        } else if (packagesToScan.length == 0 && sources.length == 0) {
            interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), type, method.getName(), packageName));
        }
        for (String source : sources) {
            Resource file = FileUtils.getFileResource((String)source);
            String sourceFilePackageName = "";
            if (source.startsWith("classpath:")) {
                sourceFilePackageName = source.substring("classpath:".length());
            }
            if (StringUtils.hasLength((String)sourceFilePackageName) && sourceFilePackageName.contains("/")) {
                sourceFilePackageName = sourceFilePackageName.substring(0, sourceFilePackageName.lastIndexOf("/"));
            }
            CitrusFrameworkMethod frameworkMethod = new CitrusFrameworkMethod(method.getMethod(), type, FileUtils.getBaseName((String)file.getFilename()), sourceFilePackageName.replace("/", "."));
            frameworkMethod.setSource(source);
            interceptedMethods.add(frameworkMethod);
        }
        for (String packageScan : packagesToScan) {
            try {
                for (String fileNamePattern : CitrusSettings.getTestFileNamePattern((String)type)) {
                    Resource[] fileResources;
                    for (Resource fileResource : fileResources = new PathMatchingResourcePatternResolver().getResources(packageScan.replace('.', File.separatorChar) + fileNamePattern)) {
                        Object filePath = fileResource.getFile().getParentFile().getCanonicalPath();
                        if (packageScan.startsWith("file:")) {
                            filePath = "file:" + (String)filePath;
                        }
                        filePath = ((String)filePath).substring(((String)filePath).indexOf(packageScan.replace('.', File.separatorChar)));
                        interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), type, FileUtils.getBaseName((String)fileResource.getFilename()), (String)filePath));
                    }
                }
            }
            catch (IOException | RuntimeException e) {
                interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), type, method.getName(), packageScan).withError((RuntimeException)new CitrusRuntimeException(String.format("Unable to locate file resources for test package '%s'", packageScan), (Throwable)e)));
            }
        }
        return interceptedMethods;
    }
}

