/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.junit;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.citrusframework.TestClass;
import org.citrusframework.main.AbstractTestEngine;
import org.citrusframework.main.TestRunConfiguration;
import org.citrusframework.main.scan.ClassPathTestScanner;
import org.citrusframework.main.scan.JarFileTestScanner;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.notification.RunListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JUnit4TestEngine
extends AbstractTestEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JUnit4TestEngine.class);
    private final List<RunListener> listeners = new ArrayList<RunListener>();

    public JUnit4TestEngine(TestRunConfiguration configuration) {
        super(configuration);
    }

    public void run() {
        if (!CollectionUtils.isEmpty((Collection)this.getConfiguration().getTestClasses())) {
            this.run(this.getConfiguration().getTestClasses());
        } else {
            List<String> packagesToRun = this.getConfiguration().getPackages();
            if (CollectionUtils.isEmpty((Collection)packagesToRun) && CollectionUtils.isEmpty((Collection)this.getConfiguration().getTestClasses())) {
                packagesToRun = Collections.singletonList("");
                LOG.info("Running all tests in project");
            }
            ArrayList<TestClass> classesToRun = new ArrayList<TestClass>();
            for (String packageName : packagesToRun) {
                if (StringUtils.hasText((String)packageName)) {
                    LOG.info(String.format("Running tests in package %s", packageName));
                }
                if (this.getConfiguration().getTestJar() != null) {
                    classesToRun.addAll(new JarFileTestScanner(this.getConfiguration().getTestJar(), this.getConfiguration().getIncludes()).findTestsInPackage(packageName));
                    continue;
                }
                classesToRun.addAll(new ClassPathTestScanner(Test.class, this.getConfiguration().getIncludes()).findTestsInPackage(packageName));
            }
            LOG.info(String.format("Found %s test classes to execute", classesToRun.size()));
            this.run(classesToRun);
        }
    }

    private void run(List<TestClass> classesToRun) {
        JUnitCore junit = new JUnitCore();
        for (RunListener listener : this.listeners) {
            junit.addListener(listener);
        }
        junit.run((Class[])classesToRun.stream().peek(testClass -> LOG.info(String.format("Running test %s", Optional.ofNullable(testClass.getMethod()).map(method -> testClass.getName() + "#" + method).orElse(testClass.getName())))).map(testClass -> {
            try {
                Class<?> clazz = this.getConfiguration().getTestJar() != null ? Class.forName(testClass.getName(), false, new URLClassLoader(new URL[]{this.getConfiguration().getTestJar().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader())) : Class.forName(testClass.getName());
                LOG.debug("Found test candidate: " + testClass.getName());
                return clazz;
            }
            catch (ClassNotFoundException | MalformedURLException e) {
                LOG.warn("Unable to read test class: " + testClass.getName());
                return Void.class;
            }
        }).filter(clazz -> !clazz.equals(Void.class)).toArray(Class[]::new));
    }

    public JUnit4TestEngine addRunListener(RunListener listener) {
        this.listeners.add(listener);
        return this;
    }
}

