/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.junit.spring;

import java.util.Date;
import java.util.Optional;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusContext;
import org.citrusframework.CitrusContextProvider;
import org.citrusframework.CitrusSpringContext;
import org.citrusframework.CitrusSpringContextProvider;
import org.citrusframework.GherkinTestActionRunner;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestBehavior;
import org.citrusframework.TestCase;
import org.citrusframework.TestCaseMetaInfo;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.annotations.CitrusTest;
import org.citrusframework.annotations.CitrusTestSource;
import org.citrusframework.common.DefaultTestLoader;
import org.citrusframework.common.TestLoader;
import org.citrusframework.common.TestSourceAware;
import org.citrusframework.config.CitrusSpringConfig;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.junit.CitrusFrameworkMethod;
import org.citrusframework.junit.JUnit4Helper;
import org.citrusframework.junit.spring.CitrusSpringJUnit4Runner;
import org.junit.runner.RunWith;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractJUnit4SpringContextTests;

@RunWith(value=CitrusSpringJUnit4Runner.class)
@ContextConfiguration(classes={CitrusSpringConfig.class})
public class JUnit4CitrusSpringSupport
extends AbstractJUnit4SpringContextTests
implements GherkinTestActionRunner,
CitrusFrameworkMethod.Runner {
    protected Citrus citrus;
    private TestCaseRunner delegate;
    private TestCase testCase;

    @Override
    public void run(CitrusFrameworkMethod frameworkMethod) {
        if (frameworkMethod.hasError()) {
            throw frameworkMethod.getError();
        }
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(this.applicationContext));
        }
        TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
        if (frameworkMethod.getMethod().getAnnotation(CitrusTest.class) != null || frameworkMethod.getMethod().getAnnotation(CitrusTestSource.class) != null) {
            DefaultTestLoader testLoader;
            TestCaseRunner runner = JUnit4Helper.createTestRunner(frameworkMethod, this.getClass(), ctx);
            frameworkMethod.setAttribute("builder", runner);
            this.delegate = runner;
            CitrusAnnotations.injectAll((Object)this, (Citrus)this.citrus, (TestContext)ctx);
            if (frameworkMethod.getMethod().getAnnotation(CitrusTestSource.class) != null) {
                testLoader = this.createTestLoader(frameworkMethod.getTestName(), frameworkMethod.getPackageName(), frameworkMethod.getSource(), frameworkMethod.getSourceType());
            } else {
                testLoader = new DefaultTestLoader();
                testLoader.configureTestCase(t -> {
                    this.testCase = t;
                });
            }
            CitrusAnnotations.injectAll((Object)testLoader, (Citrus)this.citrus, (TestContext)ctx);
            CitrusAnnotations.injectTestRunner((Object)testLoader, (TestCaseRunner)runner);
            testLoader.doWithTestCase(t -> JUnit4Helper.invokeTestMethod(this, frameworkMethod, ctx));
            testLoader.load();
        }
    }

    protected TestContext prepareTestContext(TestContext testContext) {
        return testContext;
    }

    protected TestLoader createTestLoader(String testName, String packageName, String source, String type) {
        TestLoader testLoader = (TestLoader)TestLoader.lookup((String)type).orElseThrow(() -> new CitrusRuntimeException(String.format("Missing test loader for type '%s'", type)));
        testLoader.setTestClass(this.getClass());
        testLoader.setTestName(testName);
        testLoader.setPackageName(packageName);
        if (testLoader instanceof TestSourceAware) {
            ((TestSourceAware)testLoader).setSource(source);
        }
        CitrusAnnotations.injectCitrusContext((Object)testLoader, (CitrusContext)Optional.ofNullable(this.citrus).map(Citrus::getCitrusContext).orElseGet(() -> CitrusSpringContext.create((ApplicationContext)this.applicationContext)));
        testLoader.configureTestCase(t -> {
            this.testCase = t;
        });
        return testLoader;
    }

    protected TestCase getTestCase() {
        if (this.delegate != null) {
            return this.delegate.getTestCase();
        }
        return this.testCase;
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        return (T)this.delegate.run(builder);
    }

    public <T extends TestAction> TestActionBuilder<T> applyBehavior(TestBehavior behavior) {
        return this.delegate.applyBehavior(behavior);
    }

    public <T> T variable(String name, T value) {
        return (T)this.delegate.variable(name, value);
    }

    public void name(String name) {
        this.delegate.name(name);
    }

    public void description(String description) {
        this.delegate.description(description);
    }

    public void author(String author) {
        this.delegate.author(author);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.delegate.status(status);
    }

    public void creationDate(Date date) {
        this.delegate.creationDate(date);
    }
}

