/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.junit.jupiter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusInstanceManager;
import org.citrusframework.CitrusSettings;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.common.TestLoader;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ClasspathResourceResolver;
import org.citrusframework.util.FileUtils;
import org.junit.jupiter.api.DynamicTest;

public final class CitrusTestFactorySupport {
    private final String type;
    private final Consumer<TestLoader> handler;

    public CitrusTestFactorySupport(String type, Consumer<TestLoader> handler) {
        this.type = type;
        this.handler = handler;
    }

    public static CitrusTestFactorySupport factory(String type) {
        return new CitrusTestFactorySupport(type, TestLoader::load);
    }

    public static CitrusTestFactorySupport xml() {
        return CitrusTestFactorySupport.factory("xml");
    }

    public static CitrusTestFactorySupport groovy() {
        return CitrusTestFactorySupport.factory("groovy");
    }

    public static CitrusTestFactorySupport springXml() {
        return CitrusTestFactorySupport.factory("spring");
    }

    public Stream<DynamicTest> packageScan(String ... packagesToScan) {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        for (String packageScan : packagesToScan) {
            try {
                for (String fileNamePattern : CitrusSettings.getTestFileNamePattern((String)this.type)) {
                    Set fileResources = new ClasspathResourceResolver().getResources(packageScan.replace('.', File.separatorChar), fileNamePattern);
                    for (Path fileResource : fileResources) {
                        Object filePath = fileResource.getParent().toFile().getCanonicalPath();
                        if (packageScan.startsWith("file:")) {
                            filePath = "file:" + (String)filePath;
                        }
                        filePath = ((String)filePath).substring(((String)filePath).indexOf(packageScan.replace('.', File.separatorChar)));
                        String testName = FileUtils.getBaseName((String)String.valueOf(fileResource.getFileName()));
                        TestLoader testLoader = this.createTestLoader(testName, (String)filePath);
                        tests.add(DynamicTest.dynamicTest((String)testName, () -> this.handler.accept(testLoader)));
                    }
                }
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Unable to locate file resources for test package '" + packageScan + "'", (Throwable)e);
            }
        }
        return tests.stream();
    }

    public Stream<DynamicTest> dynamicTests(String packageName, String ... testNames) {
        return Stream.of(testNames).map(testName -> {
            TestLoader testLoader = this.createTestLoader((String)testName, packageName);
            return DynamicTest.dynamicTest((String)testName, () -> this.handler.accept(testLoader));
        });
    }

    public Stream<DynamicTest> dynamicTests(Class<?> testClass, String ... testNames) {
        return Stream.of(testNames).map(testName -> {
            TestLoader testLoader = this.createTestLoader((String)testName, testClass.getPackage().getName());
            return DynamicTest.dynamicTest((String)testName, () -> this.handler.accept(testLoader));
        });
    }

    public DynamicTest dynamicTest(String packageName, String testName) {
        TestLoader testLoader = this.createTestLoader(testName, packageName);
        return DynamicTest.dynamicTest((String)testName, () -> this.handler.accept(testLoader));
    }

    private TestLoader createTestLoader(String testName, String packageName) {
        TestLoader testLoader = (TestLoader)TestLoader.lookup((String)this.type).orElseThrow(() -> new CitrusRuntimeException(String.format("Missing '%s' test loader in project classpath - please add proper Citrus module to the project", this.type)));
        testLoader.setTestClass(DynamicTest.class);
        testLoader.setTestName(testName);
        testLoader.setPackageName(packageName);
        CitrusAnnotations.injectAll((Object)testLoader, (Citrus)CitrusInstanceManager.getOrDefault());
        return testLoader;
    }
}

