/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.junit.jupiter;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.citrusframework.TestClass;
import org.citrusframework.TestSource;
import org.citrusframework.common.TestSourceHelper;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.junit.jupiter.main.JUnitCitrusTest;
import org.citrusframework.main.AbstractTestEngine;
import org.citrusframework.main.TestRunConfiguration;
import org.citrusframework.main.scan.ClassPathTestScanner;
import org.citrusframework.main.scan.JarFileTestScanner;
import org.citrusframework.spi.ClasspathResourceResolver;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.StringUtils;
import org.junit.jupiter.api.Test;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitJupiterEngine
extends AbstractTestEngine {
    private static final Logger logger = LoggerFactory.getLogger(JUnitJupiterEngine.class);
    private final Set<TestExecutionListener> testExecutionListeners = new LinkedHashSet<TestExecutionListener>();
    private boolean printSummary = true;

    public JUnitJupiterEngine(TestRunConfiguration configuration) {
        super(configuration);
    }

    public void run() {
        LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request();
        if (this.getConfiguration().getTestSources().isEmpty()) {
            this.addTestPackages(requestBuilder, this.getConfiguration());
        } else {
            this.addTestClasses(requestBuilder, this.getConfiguration());
            this.addTestSources(requestBuilder, this.getConfiguration().getTestSources());
        }
        LauncherDiscoveryRequest request = requestBuilder.build();
        SummaryGeneratingListener listener = null;
        if (this.printSummary) {
            listener = new SummaryGeneratingListener();
        }
        try (LauncherSession session = LauncherFactory.openSession();){
            Launcher launcher = session.getLauncher();
            if (!this.testExecutionListeners.isEmpty()) {
                launcher.registerTestExecutionListeners((TestExecutionListener[])this.testExecutionListeners.toArray(TestExecutionListener[]::new));
            }
            if (this.printSummary) {
                launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
            }
            launcher.execute(request, new TestExecutionListener[0]);
        }
        if (this.printSummary) {
            Optional.ofNullable(listener).map(SummaryGeneratingListener::getSummary).ifPresent(summary -> summary.printTo(new PrintWriter(System.out)));
        }
    }

    private void addTestSources(LauncherDiscoveryRequestBuilder requestBuilder, List<TestSource> testSources) {
        List<TestSource> directories = testSources.stream().filter(source -> "directory".equals(source.getType())).toList();
        for (TestSource directory : directories) {
            Resource sourceDir = Resources.create((String)directory.getFilePath());
            if (!sourceDir.exists()) continue;
            if (sourceDir instanceof Resources.ClasspathResource) {
                try {
                    this.addTestSources(requestBuilder, new ClasspathResourceResolver().getResources(sourceDir.getLocation()).stream().map(Path::toString).map(TestSourceHelper::create).collect(Collectors.toList()));
                    continue;
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to resolve files from resource directory '%s'".formatted(sourceDir.getLocation()), (Throwable)e);
                }
            }
            this.addTestSources(requestBuilder, Optional.ofNullable(sourceDir.getFile().list()).stream().flatMap(Arrays::stream).map(file -> directory.getFilePath() + File.separator + file).map(TestSourceHelper::create).collect(Collectors.toList()));
        }
        List<TestSource> filtered = testSources.stream().filter(source -> !"directory".equals(source.getType())).filter(source -> !"java".equals(source.getType()) || !TestClass.isKnownToClasspath((String)source.getName())).toList();
        for (TestSource source2 : filtered) {
            logger.info("Running test source {}", (Object)source2.getName());
            JUnitCitrusTest.setSourceName(source2.getName());
            JUnitCitrusTest.setSource(source2);
            requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(JUnitCitrusTest.class)});
        }
    }

    private void addTestPackages(LauncherDiscoveryRequestBuilder requestBuilder, TestRunConfiguration configuration) {
        List<String> packagesToRun = configuration.getPackages();
        if (packagesToRun == null || packagesToRun.isEmpty()) {
            packagesToRun = Collections.singletonList("");
            logger.info("Running all tests in project");
        }
        ArrayList selectors = new ArrayList();
        for (String packageName : packagesToRun) {
            if (StringUtils.hasText((String)packageName)) {
                logger.info("Running tests in package {}", (Object)packageName);
            }
            List classesToRun = configuration.getTestJar() != null ? new JarFileTestScanner(configuration.getTestJar(), configuration.getIncludes()).findTestsInPackage(packageName) : new ClassPathTestScanner(Test.class, configuration.getIncludes()).findTestsInPackage(packageName);
            classesToRun.stream().peek(testClass -> {
                Object[] objectArray = new Object[1];
                objectArray[0] = Optional.ofNullable(testClass.getMethod()).map(method -> testClass.getName() + "#" + method).orElseGet(() -> ((TestClass)testClass).getName());
                logger.info(String.format("Running test %s", objectArray));
            }).map(testClass -> {
                try {
                    Class<?> clazz = configuration.getTestJar() != null ? Class.forName(testClass.getName(), false, new URLClassLoader(new URL[]{configuration.getTestJar().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader())) : Class.forName(testClass.getName());
                    return clazz;
                }
                catch (ClassNotFoundException | MalformedURLException e) {
                    logger.warn("Unable to read test class: {}", (Object)testClass.getName());
                    return Void.class;
                }
            }).filter(clazz -> !clazz.equals(Void.class)).forEach(clazz -> selectors.add(DiscoverySelectors.selectClass((Class)clazz)));
            requestBuilder.selectors(selectors);
            logger.info("Found {} test classes to execute", (Object)selectors.size());
        }
    }

    private void addTestClasses(LauncherDiscoveryRequestBuilder requestBuilder, TestRunConfiguration configuration) {
        List<TestClass> testClasses = configuration.getTestSources().stream().filter(source -> "java".equals(source.getType())).map(TestSource::getName).map(TestClass::fromString).toList();
        ArrayList<Object> selectors = new ArrayList<Object>();
        for (TestClass testClass : testClasses) {
            if (logger.isInfoEnabled()) {
                logger.info("Running test {}", (Object)Optional.ofNullable(testClass.getMethod()).map(method -> testClass.getName() + "#" + method).orElseGet(() -> ((TestClass)testClass).getName()));
            }
            try {
                Class<?> clazz = configuration.getTestJar() != null ? Class.forName(testClass.getName(), false, new URLClassLoader(new URL[]{configuration.getTestJar().toURI().toURL()}, ((Object)((Object)this)).getClass().getClassLoader())) : Class.forName(testClass.getName());
                if (StringUtils.hasText((String)testClass.getMethod())) {
                    selectors.add(DiscoverySelectors.selectMethod(clazz, (String)testClass.getMethod()));
                    continue;
                }
                selectors.add(DiscoverySelectors.selectClass(clazz));
            }
            catch (ClassNotFoundException | MalformedURLException e) {
                logger.warn("Unable to read test class: {}", (Object)testClass.getName());
            }
        }
        requestBuilder.selectors(selectors);
    }

    public JUnitJupiterEngine addTestListener(TestExecutionListener testExecutionListener) {
        this.testExecutionListeners.add(testExecutionListener);
        return this;
    }

    public JUnitJupiterEngine withPrintSummary(boolean enabled) {
        this.printSummary = enabled;
        return this;
    }
}

