/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.endpoint;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kafka.endpoint.KafkaEndpointConfiguration;
import org.citrusframework.message.Message;
import org.citrusframework.messaging.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KafkaProducer
implements Producer {
    private static Logger log = LoggerFactory.getLogger(KafkaProducer.class);
    private final String name;
    private final KafkaEndpointConfiguration endpointConfiguration;
    private org.apache.kafka.clients.producer.KafkaProducer<Object, Object> producer;

    public KafkaProducer(String name, KafkaEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
        this.producer = this.createKafkaProducer();
    }

    public void send(Message message, TestContext context) {
        Assert.notNull((Object)message, (String)"Message is empty - unable to send empty message");
        String topic = Optional.ofNullable(message.getHeader("citrus_kafka_topic")).map(Object::toString).map(arg_0 -> ((TestContext)context).replaceDynamicContentInString(arg_0)).orElse(context.replaceDynamicContentInString(this.endpointConfiguration.getTopic()));
        if (!StringUtils.hasText((String)topic)) {
            throw new CitrusRuntimeException(String.format("Invalid Kafka stream topic header %s - must not be empty or null", "citrus_kafka_topic"));
        }
        if (log.isDebugEnabled()) {
            log.debug("Sending Kafka stream message to topic: '" + topic + "'");
        }
        try {
            ProducerRecord<Object, Object> producerRecord = this.endpointConfiguration.getMessageConverter().convertOutbound(message, this.endpointConfiguration, context);
            this.producer.send(producerRecord).get(this.endpointConfiguration.getTimeout(), TimeUnit.MILLISECONDS);
            log.info("Message was sent to Kafka stream topic: '" + topic + "'");
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CitrusRuntimeException(String.format("Failed to send message to Kafka topic '%s'", topic), (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new CitrusRuntimeException(String.format("Failed to send message to Kafka topic '%s' - timeout after %s milliseconds", topic, this.endpointConfiguration.getTimeout()), (Throwable)e);
        }
        context.onOutboundMessage(message);
    }

    private org.apache.kafka.clients.producer.KafkaProducer<Object, Object> createKafkaProducer() {
        HashMap<String, Object> producerProps = new HashMap<String, Object>();
        producerProps.put("bootstrap.servers", this.endpointConfiguration.getServer());
        producerProps.put("request.timeout.ms", new Long(this.endpointConfiguration.getTimeout()).intValue());
        producerProps.put("key.serializer", this.endpointConfiguration.getKeySerializer());
        producerProps.put("value.serializer", this.endpointConfiguration.getValueSerializer());
        producerProps.put("client.id", Optional.ofNullable(this.endpointConfiguration.getClientId()).orElse("citrus_kafka_producer_" + UUID.randomUUID().toString()));
        producerProps.putAll(this.endpointConfiguration.getProducerProperties());
        return new org.apache.kafka.clients.producer.KafkaProducer(producerProps);
    }

    public String getName() {
        return this.name;
    }

    public void setProducer(org.apache.kafka.clients.producer.KafkaProducer<Object, Object> producer) {
        this.producer = producer;
    }
}

