/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.endpoint;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kafka.endpoint.selector.KafkaMessageSelector;
import org.citrusframework.kafka.endpoint.selector.KafkaMessageSelectorFactory;
import org.citrusframework.message.MessageSelectorBuilder;

public final class KafkaMessageFilter {
    static final String EVENT_LOOKBACK_WINDOW = "event-lookback-window";
    static final String POLL_TIMEOUT = "poll-timeout";
    private static final String EVENT_LOOKBACK_WINDOW_EXCEPTION = "Cannot find Kafka messages without offset limitation";
    private final KafkaMessageSelectorFactory kafkaMessageSelectorFactory;
    private Duration eventLookbackWindow;
    private Duration pollTimeout = Duration.ofMillis(100L);
    private KafkaMessageSelector kafkaMessageSelector;

    static KafkaMessageFilterBuilder builder() {
        return new KafkaMessageFilterBuilder();
    }

    public static KafkaMessageFilterBuilder kafkaMessageFilter() {
        return KafkaMessageFilter.builder().kafkaMessageSelectorFactory(new KafkaMessageSelectorFactory());
    }

    static KafkaMessageFilter kafkaMessageFilter(String selector) {
        return KafkaMessageFilter.kafkaMessageFilter(selector, new KafkaMessageSelectorFactory());
    }

    static KafkaMessageFilter kafkaMessageFilter(String selector, KafkaMessageSelectorFactory kafkaMessageSelectorFactory) {
        return new KafkaMessageFilterBuilder().kafkaMessageSelectorFactory(kafkaMessageSelectorFactory).buildFilter().fromSelectorString(selector);
    }

    private KafkaMessageFilter(KafkaMessageSelectorFactory kafkaMessageSelectorFactory, Duration eventLookbackWindow, Duration pollTimeout, KafkaMessageSelector kafkaMessageSelector) {
        this.kafkaMessageSelectorFactory = kafkaMessageSelectorFactory;
        this.eventLookbackWindow = eventLookbackWindow;
        this.pollTimeout = pollTimeout;
        this.kafkaMessageSelector = kafkaMessageSelector;
    }

    KafkaMessageSelectorFactory getKafkaMessageSelectorFactory() {
        return this.kafkaMessageSelectorFactory;
    }

    Duration getEventLookbackWindow() {
        return this.eventLookbackWindow;
    }

    Duration getPollTimeout() {
        return this.pollTimeout;
    }

    KafkaMessageSelector getKafkaMessageSelector() {
        return this.kafkaMessageSelector;
    }

    private KafkaMessageFilter fromSelectorString(String selector) {
        Map messageSelectors = MessageSelectorBuilder.withString((String)selector).toKeyValueMap();
        this.eventLookbackWindow = Duration.parse(Optional.ofNullable((String)messageSelectors.get(EVENT_LOOKBACK_WINDOW)).orElseThrow(() -> new CitrusRuntimeException(EVENT_LOOKBACK_WINDOW_EXCEPTION)));
        this.pollTimeout = Duration.parse(Optional.ofNullable((String)messageSelectors.get(POLL_TIMEOUT)).orElse("PT0.100S"));
        this.kafkaMessageSelector = this.kafkaMessageSelectorFactory.parseFromSelector(messageSelectors);
        return this;
    }

    <T> Map<String, T> asSelector() {
        HashMap<String, String> selector = new HashMap<String, String>();
        if (Objects.nonNull(this.eventLookbackWindow)) {
            selector.put(EVENT_LOOKBACK_WINDOW, this.eventLookbackWindow.toString());
        }
        if (Objects.nonNull(this.pollTimeout)) {
            selector.put(POLL_TIMEOUT, this.pollTimeout.toString());
        }
        if (Objects.nonNull(this.kafkaMessageSelector)) {
            selector.putAll(this.kafkaMessageSelector.asSelector());
        }
        return selector;
    }

    void sanitize() {
        if (Objects.isNull(this.eventLookbackWindow)) {
            throw new CitrusRuntimeException(EVENT_LOOKBACK_WINDOW_EXCEPTION);
        }
        if (Objects.isNull(this.pollTimeout)) {
            throw new CitrusRuntimeException("No poll timeout defined when looking for Kafka messages");
        }
        if (Objects.isNull(this.kafkaMessageSelector)) {
            throw new CitrusRuntimeException("No matcher specified when looking for Kafka messages");
        }
    }

    public String toString() {
        return "KafkaMessageFilter{kafkaMessageSelectorFactory=" + this.kafkaMessageSelectorFactory + ", eventLookbackWindow=" + this.eventLookbackWindow + ", pollTimeout=" + this.pollTimeout + ", kafkaMessageSelector=" + this.kafkaMessageSelector + "}";
    }

    public static class KafkaMessageFilterBuilder {
        private KafkaMessageSelectorFactory kafkaMessageSelectorFactory;
        private Duration eventLookbackWindow;
        private Duration pollTimeout = Duration.ofMillis(100L);
        private KafkaMessageSelector kafkaMessageSelector;

        KafkaMessageFilterBuilder kafkaMessageSelectorFactory(KafkaMessageSelectorFactory kafkaMessageSelectorFactory) {
            this.kafkaMessageSelectorFactory = kafkaMessageSelectorFactory;
            return this;
        }

        public KafkaMessageFilterBuilder eventLookbackWindow(Duration eventLookbackWindow) {
            this.eventLookbackWindow = eventLookbackWindow;
            return this;
        }

        public KafkaMessageFilterBuilder pollTimeout(Duration pollTimeout) {
            this.pollTimeout = pollTimeout;
            return this;
        }

        public KafkaMessageFilterBuilder kafkaMessageSelector(KafkaMessageSelector kafkaMessageSelector) {
            this.kafkaMessageSelector = kafkaMessageSelector;
            return this;
        }

        public <T> Map<String, T> build() {
            return this.buildFilter().asSelector();
        }

        public KafkaMessageFilter buildFilter() {
            return new KafkaMessageFilter(this.kafkaMessageSelectorFactory, this.eventLookbackWindow, this.pollTimeout, this.kafkaMessageSelector);
        }
    }
}

