/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.config.xml;

import org.apache.commons.lang3.RandomStringUtils;
import org.citrusframework.config.util.BeanDefinitionParserUtils;
import org.citrusframework.config.xml.AbstractEndpointParser;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.kafka.endpoint.KafkaEndpoint;
import org.citrusframework.kafka.endpoint.KafkaEndpointConfiguration;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class KafkaEndpointParser
extends AbstractEndpointParser {
    protected void parseEndpointConfiguration(BeanDefinitionBuilder endpointConfiguration, Element element, ParserContext parserContext) {
        super.parseEndpointConfiguration(endpointConfiguration, element, parserContext);
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("client-id"), (String)"clientId");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("server"), (String)"server");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("topic"), (String)"topic");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("partition"), (String)"partition");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("message-converter"), (String)"messageConverter");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("header-mapper"), (String)"headerMapper");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("producer-properties"), (String)"producerProperties");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("consumer-properties"), (String)"consumerProperties");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("auto-commit"), (String)"autoCommit");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("auto-commit-interval"), (String)"autoCommitInterval");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("offset-reset"), (String)"offsetReset");
        if (Boolean.parseBoolean(element.getAttribute("random-consumer-group"))) {
            BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)("citrus_kafka_" + RandomStringUtils.insecure().nextAlphabetic(10).toLowerCase()), (String)"consumerGroup");
        } else {
            BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("consumer-group"), (String)"consumerGroup");
        }
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("key-serializer"), (String)"keySerializer");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("key-deserializer"), (String)"keyDeserializer");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("value-serializer"), (String)"valueSerializer");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("value-deserializer"), (String)"valueDeserializer");
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("thread-safe-consumer"), (String)"useThreadSafeConsumer");
    }

    protected Class<? extends Endpoint> getEndpointClass() {
        return KafkaEndpoint.class;
    }

    protected Class<? extends EndpointConfiguration> getEndpointConfigurationClass() {
        return KafkaEndpointConfiguration.class;
    }
}

