/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.endpoint;

import java.util.List;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kafka.endpoint.KafkaEndpointConfiguration;
import org.citrusframework.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KafkaMessageConsumerUtils {
    private static final Logger logger = LoggerFactory.getLogger(KafkaMessageConsumerUtils.class);

    static String resolveTopic(KafkaEndpointConfiguration kafkaEndpointConfiguration, TestContext testContext) {
        return testContext.replaceDynamicContentInString(Optional.ofNullable(kafkaEndpointConfiguration.getTopic()).orElseThrow(() -> new CitrusRuntimeException("Missing Kafka topic to receive messages from - add topic to endpoint configuration")));
    }

    static Message parseConsumerRecordsToMessage(List<ConsumerRecord<Object, Object>> consumerRecords, KafkaEndpointConfiguration endpointConfiguration, TestContext testContext) {
        if (consumerRecords.size() > 1) {
            throw new CitrusRuntimeException("More than one matching record found in topic " + KafkaMessageConsumerUtils.resolveTopic(endpointConfiguration, testContext));
        }
        if (logger.isDebugEnabled()) {
            consumerRecords.forEach(record -> logger.debug("Received message: ({}, {}) at offset {}", new Object[]{record.key(), record.value(), record.offset()}));
        }
        Message received = endpointConfiguration.getMessageConverter().convertInbound(consumerRecords.iterator().next(), endpointConfiguration, testContext);
        testContext.onInboundMessage(received);
        return received;
    }

    private KafkaMessageConsumerUtils() {
    }
}

