/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.endpoint.selector;

import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kafka.endpoint.selector.KafkaMessageSelector;
import org.citrusframework.util.StringUtils;

public class KafkaMessageByHeaderSelector
implements KafkaMessageSelector<String> {
    static final String HEADER_FILTER_KEY = "header-filter-key";
    static final String HEADER_FILTER_VALUE = "header-filter-value";
    static final String HEADER_FILTER_COMPARATOR = "header-filter-comparator";
    @Nullable
    private String key;
    @Nullable
    private String value;
    @Nullable
    private ValueMatchingStrategy valueMatchingStrategy;

    public static KafkaMessageByHeaderSelectorBuilder builder() {
        return new KafkaMessageByHeaderSelectorBuilder();
    }

    public static KafkaMessageByHeaderSelector kafkaHeaderContains(String key, String value) {
        return KafkaMessageByHeaderSelector.keyValueBuilder(key, value).valueMatchingStrategy(ValueMatchingStrategy.CONTAINS).build();
    }

    public static KafkaMessageByHeaderSelector kafkaHeaderEquals(String key, String value) {
        return KafkaMessageByHeaderSelector.keyValueBuilder(key, value).valueMatchingStrategy(ValueMatchingStrategy.EQUALS).build();
    }

    static <T> KafkaMessageByHeaderSelector fromSelector(Map<String, T> messageSelectors) {
        String keyFilter = Optional.ofNullable(messageSelectors.get(HEADER_FILTER_KEY)).map(Object::toString).orElse("");
        String valueFilter = Optional.ofNullable(messageSelectors.get(HEADER_FILTER_VALUE)).map(Objects::toString).orElse(null);
        String comparator = Optional.ofNullable(messageSelectors.get(HEADER_FILTER_COMPARATOR)).map(Object::toString).orElse(ValueMatchingStrategy.EQUALS.toString());
        if (StringUtils.isEmpty((String)keyFilter) && StringUtils.isEmpty((String)valueFilter)) {
            throw new CitrusRuntimeException("No matcher specified when looking for Kafka messages");
        }
        return KafkaMessageByHeaderSelector.builder().key(keyFilter).value(valueFilter).valueMatchingStrategy(ValueMatchingStrategy.valueOf(comparator.toUpperCase())).build();
    }

    private static KafkaMessageByHeaderSelectorBuilder keyValueBuilder(String key, String value) {
        return KafkaMessageByHeaderSelector.builder().key(key).value(value);
    }

    private KafkaMessageByHeaderSelector(@Nullable String key, @Nullable String value, @Nullable ValueMatchingStrategy valueMatchingStrategy) {
        this.key = key;
        this.value = value;
        this.valueMatchingStrategy = valueMatchingStrategy;
    }

    @Nullable
    String getKey() {
        return this.key;
    }

    @Nullable
    String getValue() {
        return this.value;
    }

    @Nullable
    ValueMatchingStrategy getValueMatchingStrategy() {
        return this.valueMatchingStrategy;
    }

    @Override
    public boolean matches(ConsumerRecord<Object, Object> consumerRecord) {
        Headers headers = consumerRecord.headers();
        for (Header header : headers) {
            if (!StringUtils.isEmpty((String)this.key) && !header.key().equals(this.key) || !this.matchesValue(header.value())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> asSelector() {
        HashMap<String, String> selector = new HashMap<String, String>();
        if (Objects.nonNull(this.key)) {
            selector.put(HEADER_FILTER_KEY, this.key);
        }
        if (Objects.nonNull(this.value)) {
            selector.put(HEADER_FILTER_VALUE, this.value);
        }
        selector.put(HEADER_FILTER_COMPARATOR, Optional.ofNullable(this.valueMatchingStrategy).orElse(ValueMatchingStrategy.EQUALS).toString());
        return selector;
    }

    private boolean matchesValue(byte[] headerValue) {
        if (Objects.isNull(this.value)) {
            return true;
        }
        String headerValueString = new String(headerValue, StandardCharsets.UTF_8);
        if (Objects.isNull((Object)this.valueMatchingStrategy)) {
            return headerValueString.equals(this.value);
        }
        return switch (this.valueMatchingStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case ValueMatchingStrategy.EQUALS -> headerValueString.equals(this.value);
            case ValueMatchingStrategy.CONTAINS -> headerValueString.contains(this.value);
            case ValueMatchingStrategy.STARTS_WITH -> headerValueString.startsWith(this.value);
            case ValueMatchingStrategy.ENDS_WITH -> headerValueString.endsWith(this.value);
        };
    }

    public String toString() {
        return "KafkaMessageByHeaderSelector{key='" + this.key + "', value='" + this.value + "', valueMatchingStrategy=" + this.valueMatchingStrategy + "}";
    }

    public static class KafkaMessageByHeaderSelectorBuilder {
        private String key;
        private String value;
        private ValueMatchingStrategy valueMatchingStrategy;

        public KafkaMessageByHeaderSelectorBuilder key(String key) {
            this.key = key;
            return this;
        }

        public KafkaMessageByHeaderSelectorBuilder value(String value) {
            this.value = value;
            return this;
        }

        public KafkaMessageByHeaderSelectorBuilder valueMatchingStrategy(ValueMatchingStrategy valueMatchingStrategy) {
            this.valueMatchingStrategy = valueMatchingStrategy;
            return this;
        }

        public KafkaMessageByHeaderSelector build() {
            return new KafkaMessageByHeaderSelector(this.key, this.value, this.valueMatchingStrategy);
        }
    }

    public static enum ValueMatchingStrategy {
        EQUALS,
        CONTAINS,
        STARTS_WITH,
        ENDS_WITH;

    }
}

