/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.endpoint.selector;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kafka.endpoint.selector.KafkaMessageByHeaderSelector;
import org.citrusframework.kafka.endpoint.selector.KafkaMessageSelector;

public class KafkaMessageSelectorFactory {
    private static final KafkaMessageSelectorFactories strategies = new KafkaMessageSelectorFactories();
    private final KafkaMessageSelectorFactories customStrategies = new KafkaMessageSelectorFactories();

    public void setCustomStrategies(KafkaMessageSelectorFactories customStrategies) {
        this.customStrategies.putAll(customStrategies);
    }

    public <T> KafkaMessageSelector parseFromSelector(Map<String, T> messageSelectors) {
        return Stream.concat(strategies.entrySet().stream(), this.customStrategies.entrySet().stream()).filter(strategy -> ((Predicate)strategy.getKey()).test(messageSelectors)).findFirst().map(Map.Entry::getValue).map(supplier -> (KafkaMessageSelector)supplier.apply(messageSelectors)).orElseThrow(() -> new CitrusRuntimeException("Cannot instantiate Kafka matcher from selectors: " + messageSelectors));
    }

    static {
        strategies.put(messageSelectors -> messageSelectors.containsKey("header-filter-key") || messageSelectors.containsKey("header-filter-value"), KafkaMessageByHeaderSelector::fromSelector);
    }

    public static final class KafkaMessageSelectorFactories
    extends HashMap<Predicate<Map<String, Object>>, Function<Map<String, Object>, KafkaMessageSelector>> {
        public static KafkaMessageSelectorFactories factoryWithKafkaMessageSelector(Predicate<Map<String, Object>> selector, Function<Map<String, Object>, KafkaMessageSelector> initializer) {
            KafkaMessageSelectorFactories kafkaMessageSelectorFactories = new KafkaMessageSelectorFactories();
            kafkaMessageSelectorFactories.put(selector, initializer);
            return kafkaMessageSelectorFactories;
        }
    }
}

