/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.message;

import java.util.Map;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.DefaultMessage;

public class KafkaMessage
extends DefaultMessage {
    public KafkaMessage() {
    }

    public KafkaMessage(Object payload, Map<String, Object> headers) {
        super(payload, headers);
    }

    public KafkaMessage(Object payload) {
        super(payload);
    }

    public KafkaMessage partition(int partition) {
        this.setHeader("citrus_kafka_partition", partition);
        return this;
    }

    public KafkaMessage timestamp(Long timestamp) {
        this.setHeader("citrus_kafka_timestamp", timestamp);
        return this;
    }

    public KafkaMessage offset(long offset) {
        this.setHeader("citrus_kafka_offset", offset);
        return this;
    }

    public KafkaMessage messageKey(Object key) {
        this.setHeader("citrus_kafka_messageKey", key);
        return this;
    }

    public KafkaMessage topic(String topic) {
        this.setHeader("citrus_kafka_topic", topic);
        return this;
    }

    public Integer getPartition() {
        Object partition = this.getHeader("citrus_kafka_partition");
        if (partition != null) {
            if (partition instanceof Integer) {
                Integer partitionInteger = (Integer)partition;
                return partitionInteger;
            }
            if (partition instanceof String) {
                String partitionString = (String)partition;
                return Integer.parseInt(partitionString);
            }
            throw new CitrusRuntimeException(String.format("Failed to convert partition header to proper Integer value: %s", partition.getClass()));
        }
        return null;
    }

    public Long getTimestamp() {
        Object timestamp = this.getHeader("citrus_kafka_timestamp");
        if (timestamp != null) {
            return Long.valueOf(timestamp.toString());
        }
        return null;
    }

    public Long getOffset() {
        Object offset = this.getHeader("citrus_kafka_offset");
        if (offset != null) {
            if (offset instanceof Long) {
                Long longOffset = (Long)offset;
                return longOffset;
            }
            if (offset instanceof String) {
                String stringOffset = (String)offset;
                return Long.parseLong(stringOffset);
            }
            throw new CitrusRuntimeException(String.format("Failed to convert partition header to proper Long value: %s", offset.getClass()));
        }
        return 0L;
    }

    public Object getMessageKey() {
        return this.getHeader("citrus_kafka_messageKey");
    }

    public String getTopic() {
        Object topic = this.getHeader("citrus_kafka_topic");
        if (topic != null) {
            return topic.toString();
        }
        return null;
    }
}

