/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.citrusframework.TestActor;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesActor
extends TestActor {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesActor.class);
    private static AtomicBoolean connected;

    public KubernetesActor() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KubernetesActor(KubernetesClient kubernetesClient) {
        super("k8s");
        Logger logger = KubernetesActor.logger;
        synchronized (logger) {
            if (connected == null) {
                if (kubernetesClient != null) {
                    connected = new AtomicBoolean(KubernetesActor.verifyConnected(kubernetesClient));
                } else {
                    try (KubernetesClient tempClient = new KubernetesClientBuilder().build();){
                        connected = new AtomicBoolean(KubernetesActor.verifyConnected(tempClient));
                    }
                }
            }
        }
    }

    public boolean isDisabled() {
        if (!KubernetesSettings.isEnabled()) {
            return true;
        }
        return !connected.get() || super.isDisabled();
    }

    public static boolean verifyConnected(KubernetesClient kubernetesClient) {
        try {
            Future<Boolean> future = Executors.newSingleThreadExecutor().submit(() -> {
                MixedOperation pods = kubernetesClient.pods();
                if (pods == null) {
                    logger.warn("Skipping Kubernetes actions as no proper Kubernetes environment is available on host system!");
                    return false;
                }
                pods.list();
                return true;
            });
            return future.get(KubernetesSettings.getConnectTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("Skipping Kubernetes actions as no proper Kubernetes environment is available on host system! Caused by: %s - %s".formatted(e.getClass(), e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetConnectionState() {
        Logger logger = KubernetesActor.logger;
        synchronized (logger) {
            connected = null;
        }
    }
}

