/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.citrusframework.kubernetes.ClusterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesSettings {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesSettings.class);
    private static final String KUBERNETES_PROPERTY_PREFIX = "citrus.kubernetes.";
    private static final String KUBERNETES_ENV_PREFIX = "CITRUS_KUBERNETES_";
    private static final String AUTO_REMOVE_RESOURCES_PROPERTY = "citrus.kubernetes.auto.remove.resources";
    private static final String AUTO_REMOVE_RESOURCES_ENV = "CITRUS_KUBERNETES_AUTO_REMOVE_RESOURCES";
    private static final String AUTO_REMOVE_RESOURCES_DEFAULT = "true";
    private static final String ENABLED_PROPERTY = "citrus.kubernetes.enabled";
    private static final String ENABLED_ENV = "CITRUS_KUBERNETES_ENABLED";
    private static final String ENABLED_DEFAULT = "true";
    private static final String USE_DEFAULT_ACTOR_PROPERTY = "citrus.kubernetes.use.default.actor";
    private static final String USE_DEFAULT_ACTOR_ENV = "CITRUS_KUBERNETES_USE_DEFAULT_ACTOR";
    private static final String USE_DEFAULT_ACTOR_DEFAULT = "false";
    private static final String AUTO_CREATE_SERVER_BINDING_PROPERTY = "citrus.kubernetes.auto.create.server.binding";
    private static final String AUTO_CREATE_SERVER_BINDING_ENV = "CITRUS_KUBERNETES_AUTO_CREATE_SERVER_BINDING";
    private static final String AUTO_CREATE_SERVER_BINDING_DEFAULT = "true";
    private static final String CLUSTER_TYPE_PROPERTY = "citrus.kubernetes.cluster.type";
    private static final String CLUSTER_TYPE_ENV = "CITRUS_KUBERNETES_CLUSTER_TYPE";
    private static final String CLUSTER_TYPE_DEFAULT = ClusterType.KUBERNETES.name();
    private static final String CLUSTER_WILDCARD_DOMAIN_PROPERTY = "citrus.kubernetes.cluster.wildcard.domain";
    private static final String CLUSTER_WILDCARD_DOMAIN_ENV = "CITRUS_KUBERNETES_CLUSTER_WILDCARD_DOMAIN";
    public static final String DEFAULT_DOMAIN_SUFFIX = "svc.cluster.local";
    private static final String SERVICE_TIMEOUT_PROPERTY = "citrus.kubernetes.service.timeout";
    private static final String SERVICE_TIMEOUT_ENV = "CITRUS_KUBERNETES_SERVICE_TIMEOUT";
    private static final String SERVICE_TIMEOUT_DEFAULT = "2000";
    private static final String CONNECT_TIMEOUT_PROPERTY = "citrus.kubernetes.connect.timeout";
    private static final String CONNECT_TIMEOUT_ENV = "CITRUS_KUBERNETES_CONNECT_TIMEOUT";
    private static final String CONNECT_TIMEOUT_DEFAULT = "5000";
    private static final String NAMESPACE_PROPERTY = "citrus.kubernetes.namespace";
    private static final String NAMESPACE_ENV = "CITRUS_KUBERNETES_NAMESPACE";
    private static final String NAMESPACE_DEFAULT = "default";
    private static final String TEST_ID_LABEL_PROPERTY = "citrus.kubernetes.test.id.label";
    private static final String TEST_ID_LABEL_ENV = "CITRUS_KUBERNETES_TEST_ID_LABEL";
    private static final String TEST_ID_LABEL_DEFAULT = "citrusframework.org/test-id";
    private static final String API_VERSION_PROPERTY = "citrus.kubernetes.api.version";
    private static final String API_VERSION_ENV = "CITRUS_KUBERNETES_API_VERSION";
    private static final String API_VERSION_DEFAULT = "v1";
    private static final String SERVICE_NAME_PROPERTY = "citrus.kubernetes.service.name";
    private static final String SERVICE_NAME_ENV = "CITRUS_KUBERNETES_SERVICE_NAME";
    private static final String SERVICE_NAME_DEFAULT = "citrus-k8s-service";
    private static final String SERVICE_PORT_PROPERTY = "citrus.kubernetes.service.port";
    private static final String SERVICE_PORT_ENV = "CITRUS_KUBERNETES_SERVICE_PORT";
    private static final String SERVICE_PORT_DEFAULT = "8080";
    private static final String DEFAULT_LABELS_PROPERTY = "citrus.kubernetes.default.labels";
    private static final String DEFAULT_LABELS_ENV = "CITRUS_KUBERNETES_DEFAULT_LABELS";
    private static final String DEFAULT_LABELS_DEFAULT = "app=citrus";
    private static final String MAX_ATTEMPTS_PROPERTY = "citrus.kubernetes.max.attempts";
    private static final String MAX_ATTEMPTS_ENV = "CITRUS_KUBERNETES_MAX_ATTEMPTS";
    private static final String MAX_ATTEMPTS_DEFAULT = "150";
    private static final String DELAY_BETWEEN_ATTEMPTS_PROPERTY = "citrus.kubernetes.delay.between.attempts";
    private static final String DELAY_BETWEEN_ATTEMPTS_ENV = "CITRUS_KUBERNETES_DELAY_BETWEEN_ATTEMPTS";
    private static final String DELAY_BETWEEN_ATTEMPTS_DEFAULT = "2000";
    private static final String PRINT_POD_LOGS_PROPERTY = "citrus.kubernetes.print.pod.logs";
    private static final String PRINT_POD_LOGS_ENV = "CITRUS_KUBERNETES_PRINT_POD_LOGS";
    private static final String PRINT_POD_LOGS_DEFAULT = "true";
    private static final String WATCH_LOGS_TIMEOUT_PROPERTY = "citrus.kubernetes.watch.logs.timeout";
    private static final String WATCH_LOGS_TIMEOUT_ENV = "CITRUS_KUBERNETES_WATCH_LOGS_TIMEOUT";
    private static final String WATCH_LOGS_TIMEOUT_DEFAULT = "60000";

    private KubernetesSettings() {
    }

    public static long getServiceTimeout() {
        return Long.parseLong(System.getProperty(SERVICE_TIMEOUT_PROPERTY, System.getenv(SERVICE_TIMEOUT_ENV) != null ? System.getenv(SERVICE_TIMEOUT_ENV) : "2000"));
    }

    public static long getConnectTimeout() {
        return Long.parseLong(System.getProperty(CONNECT_TIMEOUT_PROPERTY, System.getenv(CONNECT_TIMEOUT_ENV) != null ? System.getenv(CONNECT_TIMEOUT_ENV) : CONNECT_TIMEOUT_DEFAULT));
    }

    public static String getNamespace() {
        String systemNamespace = System.getProperty(NAMESPACE_PROPERTY, System.getenv(NAMESPACE_ENV));
        if (systemNamespace != null) {
            return systemNamespace;
        }
        File namespace = new File("/var/run/secrets/kubernetes.io/serviceaccount/namespace");
        if (namespace.exists()) {
            try {
                return Files.readString(namespace.toPath());
            }
            catch (IOException e) {
                logger.warn("Failed to read Kubernetes namespace from filesystem {}", (Object)namespace, (Object)e);
            }
        }
        return NAMESPACE_DEFAULT;
    }

    public static String getClusterWildcardDomain() {
        return System.getProperty(CLUSTER_WILDCARD_DOMAIN_PROPERTY, (String)(System.getenv(CLUSTER_WILDCARD_DOMAIN_ENV) != null ? System.getenv(CLUSTER_WILDCARD_DOMAIN_ENV) : KubernetesSettings.getNamespace() + ".svc.cluster.local"));
    }

    public static ClusterType getClusterType() {
        return ClusterType.valueOf(System.getProperty(CLUSTER_TYPE_PROPERTY, System.getenv(CLUSTER_TYPE_ENV) != null ? System.getenv(CLUSTER_TYPE_ENV) : CLUSTER_TYPE_DEFAULT).toUpperCase(Locale.US));
    }

    public static String getApiVersion() {
        return System.getProperty(API_VERSION_PROPERTY, System.getenv(API_VERSION_ENV) != null ? System.getenv(API_VERSION_ENV) : API_VERSION_DEFAULT);
    }

    public static String getServiceName() {
        return System.getProperty(SERVICE_NAME_PROPERTY, System.getenv(SERVICE_NAME_ENV) != null ? System.getenv(SERVICE_NAME_ENV) : SERVICE_NAME_DEFAULT);
    }

    public static int getServicePort() {
        return Integer.parseInt(System.getProperty(SERVICE_PORT_PROPERTY, System.getenv(SERVICE_PORT_ENV) != null ? System.getenv(SERVICE_PORT_ENV) : SERVICE_PORT_DEFAULT));
    }

    public static Map<String, String> getDefaultLabels() {
        String labelsConfig = System.getProperty(DEFAULT_LABELS_PROPERTY, System.getenv(DEFAULT_LABELS_ENV) != null ? System.getenv(DEFAULT_LABELS_ENV) : DEFAULT_LABELS_DEFAULT);
        return Stream.of(labelsConfig.split(",")).map(item -> item.split("=", 2)).filter(keyValue -> ((String[])keyValue).length == 2).collect(Collectors.toMap(item -> item[0], item -> item[1]));
    }

    public static boolean isAutoCreateServerBinding() {
        return Boolean.parseBoolean(System.getProperty(AUTO_CREATE_SERVER_BINDING_PROPERTY, System.getenv(AUTO_CREATE_SERVER_BINDING_ENV) != null ? System.getenv(AUTO_CREATE_SERVER_BINDING_ENV) : "true"));
    }

    public static boolean isEnabled() {
        return Boolean.parseBoolean(System.getProperty(ENABLED_PROPERTY, System.getenv(ENABLED_ENV) != null ? System.getenv(ENABLED_ENV) : "true"));
    }

    public static boolean isAutoRemoveResources() {
        return Boolean.parseBoolean(System.getProperty(AUTO_REMOVE_RESOURCES_PROPERTY, System.getenv(AUTO_REMOVE_RESOURCES_ENV) != null ? System.getenv(AUTO_REMOVE_RESOURCES_ENV) : "true"));
    }

    public static boolean isPrintPodLogs() {
        return Boolean.parseBoolean(System.getProperty(PRINT_POD_LOGS_PROPERTY, System.getenv(PRINT_POD_LOGS_ENV) != null ? System.getenv(PRINT_POD_LOGS_ENV) : "true"));
    }

    public static int getMaxAttempts() {
        return Integer.parseInt(System.getProperty(MAX_ATTEMPTS_PROPERTY, System.getenv(MAX_ATTEMPTS_ENV) != null ? System.getenv(MAX_ATTEMPTS_ENV) : MAX_ATTEMPTS_DEFAULT));
    }

    public static long getDelayBetweenAttempts() {
        return Long.parseLong(System.getProperty(DELAY_BETWEEN_ATTEMPTS_PROPERTY, System.getenv(DELAY_BETWEEN_ATTEMPTS_ENV) != null ? System.getenv(DELAY_BETWEEN_ATTEMPTS_ENV) : "2000"));
    }

    public static long getWatchLogsTimeout() {
        return Long.parseLong(System.getProperty(WATCH_LOGS_TIMEOUT_PROPERTY, System.getenv(WATCH_LOGS_TIMEOUT_ENV) != null ? System.getenv(WATCH_LOGS_TIMEOUT_ENV) : WATCH_LOGS_TIMEOUT_DEFAULT));
    }

    public static boolean isLocal() {
        return KubernetesSettings.isLocal(KubernetesSettings.getClusterType());
    }

    public static boolean isLocal(ClusterType clusterType) {
        return ClusterType.LOCAL.equals((Object)clusterType);
    }

    public static boolean isOpenshiftCluster() {
        return ClusterType.OPENSHIFT.equals((Object)KubernetesSettings.getClusterType());
    }

    public static boolean isKubernetesCluster() {
        return ClusterType.KUBERNETES.equals((Object)KubernetesSettings.getClusterType());
    }

    public static String getTestIdLabel() {
        return System.getProperty(TEST_ID_LABEL_PROPERTY, System.getenv(TEST_ID_LABEL_ENV) != null ? System.getenv(TEST_ID_LABEL_ENV) : TEST_ID_LABEL_DEFAULT);
    }

    public static boolean isUseDefaultKubernetesActor() {
        return Boolean.parseBoolean(System.getProperty(USE_DEFAULT_ACTOR_PROPERTY, System.getenv(USE_DEFAULT_ACTOR_ENV) != null ? System.getenv(USE_DEFAULT_ACTOR_ENV) : USE_DEFAULT_ACTOR_DEFAULT));
    }
}

