/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.kubernetes.KubernetesActor;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.actions.KubernetesAction;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKubernetesAction
extends AbstractTestAction
implements KubernetesAction {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final KubernetesClient kubernetesClient;
    private final String namespace;
    private final boolean autoRemoveResources;

    public AbstractKubernetesAction(String name, Builder<?, ?> builder) {
        super("k8s:" + name, builder);
        this.kubernetesClient = builder.kubernetesClient;
        this.namespace = builder.namespace;
        this.autoRemoveResources = builder.autoRemoveResources;
        this.setActor(builder.getActor());
    }

    @Override
    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isAutoRemoveResources() {
        return this.autoRemoveResources;
    }

    public static abstract class Builder<T extends KubernetesAction, B extends Builder<T, B>>
    extends AbstractTestActionBuilder<T, B>
    implements ReferenceResolverAware {
        private KubernetesClient kubernetesClient;
        private String namespace;
        private boolean autoRemoveResources = KubernetesSettings.isAutoRemoveResources();
        private ReferenceResolver referenceResolver;

        public B client(KubernetesClient kubernetesClient) {
            this.kubernetesClient = kubernetesClient;
            return (B)((Object)((Builder)this.self));
        }

        public B inNamespace(String namespace) {
            this.namespace = namespace;
            return (B)((Object)((Builder)this.self));
        }

        public B autoRemoveResources(boolean enabled) {
            this.autoRemoveResources = enabled;
            return (B)((Object)((Builder)this.self));
        }

        public B withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return (B)((Object)((Builder)this.self));
        }

        public final T build() {
            if (this.kubernetesClient == null && this.referenceResolver != null && this.referenceResolver.isResolvable(KubernetesClient.class)) {
                this.kubernetesClient = (KubernetesClient)this.referenceResolver.resolve(KubernetesClient.class);
            }
            if (this.getActor() == null && KubernetesSettings.isUseDefaultKubernetesActor()) {
                this.actor(new KubernetesActor(this.kubernetesClient));
            }
            return this.doBuild();
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        protected abstract T doBuild();
    }
}

