/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.KubernetesAction;
import org.citrusframework.kubernetes.actions.KubernetesActionBuilder;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;

public class CreateConfigMapAction
extends AbstractKubernetesAction
implements KubernetesAction {
    private final String configMapName;
    private final List<String> filePaths;
    private final Map<String, String> properties;

    public CreateConfigMapAction(Builder builder) {
        super("create-config-map", builder);
        this.configMapName = builder.configMapName;
        this.filePaths = builder.filePaths;
        this.properties = builder.properties;
    }

    public void doExecute(TestContext context) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        for (String filePath : this.filePaths) {
            try {
                Resource file = FileUtils.getFileResource((String)filePath, (TestContext)context);
                String resolvedFileContent = context.replaceDynamicContentInString(FileUtils.readToString((Resource)file, (Charset)StandardCharsets.UTF_8));
                data.put(FileUtils.getFileName((String)file.getLocation()), Base64.getEncoder().encodeToString(resolvedFileContent.getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to create config map from filepath", (Throwable)e);
            }
        }
        context.resolveDynamicValuesInMap(this.properties).forEach((k, v) -> data.put((String)k, Base64.getEncoder().encodeToString(v.getBytes(StandardCharsets.UTF_8))));
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withNamespace(this.namespace(context))).withName(context.replaceDynamicContentInString(this.configMapName))).endMetadata()).withData(data)).build();
        ((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)this.getKubernetesClient().configMaps().inNamespace(this.namespace(context))).resource((Object)configMap)).createOr(Updatable::update);
        if (this.isAutoRemoveResources()) {
            context.doFinally(KubernetesActionBuilder.kubernetes().client(this.getKubernetesClient()).configMaps().delete(this.configMapName).inNamespace(this.getNamespace()));
        }
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<CreateConfigMapAction, Builder> {
        private String configMapName;
        private final List<String> filePaths = new ArrayList<String>();
        private final Map<String, String> properties = new HashMap<String, String>();

        public Builder configMap(String configMapName) {
            this.configMapName = configMapName;
            return this;
        }

        public Builder fromFile(String filePath) {
            this.filePaths.add(filePath);
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        @Override
        public CreateConfigMapAction doBuild() {
            return new CreateConfigMapAction(this);
        }
    }
}

