/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.KubernetesAction;
import org.citrusframework.kubernetes.actions.KubernetesActionBuilder;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;

public class CreateSecretAction
extends AbstractKubernetesAction
implements KubernetesAction {
    private final String secretName;
    private final List<String> filePaths;
    private final Map<String, String> properties;

    public CreateSecretAction(Builder builder) {
        super("create-secret", builder);
        this.secretName = builder.secretName;
        this.filePaths = builder.filePaths;
        this.properties = builder.properties;
    }

    public void doExecute(TestContext context) {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        for (String filePath : this.filePaths) {
            try {
                Resource file = FileUtils.getFileResource((String)filePath, (TestContext)context);
                String resolvedFileContent = context.replaceDynamicContentInString(FileUtils.readToString((Resource)file, (Charset)StandardCharsets.UTF_8));
                data.put(FileUtils.getFileName((String)file.getLocation()), Base64.getEncoder().encodeToString(resolvedFileContent.getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to create secret from filepath", (Throwable)e);
            }
        }
        context.resolveDynamicValuesInMap(this.properties).forEach((k, v) -> data.put((String)k, Base64.getEncoder().encodeToString(v.getBytes(StandardCharsets.UTF_8))));
        Secret secret = ((SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)new SecretBuilder().withNewMetadata().withNamespace(this.namespace(context))).withName(context.replaceDynamicContentInString(this.secretName))).endMetadata()).withType("generic")).withData(data)).build();
        Secret created = (Secret)((io.fabric8.kubernetes.client.dsl.Resource)((NonNamespaceOperation)this.getKubernetesClient().secrets().inNamespace(this.namespace(context))).resource((Object)secret)).createOr(Updatable::update);
        if (this.isAutoRemoveResources()) {
            context.doFinally(KubernetesActionBuilder.kubernetes().client(this.getKubernetesClient()).secrets().delete(created.getMetadata().getName()).inNamespace(this.getNamespace()));
        }
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<CreateSecretAction, Builder> {
        private String secretName;
        private final List<String> filePaths = new ArrayList<String>();
        private final Map<String, String> properties = new HashMap<String, String>();

        public Builder secret(String secretName) {
            this.secretName = secretName;
            return this;
        }

        public Builder fromFile(String filePath) {
            this.filePaths.add(filePath);
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        @Override
        public CreateSecretAction doBuild() {
            return new CreateSecretAction(this);
        }
    }
}

