/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.CitrusSettings;
import org.citrusframework.context.TestContext;
import org.citrusframework.http.server.HttpServer;
import org.citrusframework.http.server.HttpServerBuilder;
import org.citrusframework.kubernetes.KubernetesSettings;
import org.citrusframework.kubernetes.KubernetesVariableNames;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;
import org.citrusframework.kubernetes.actions.KubernetesActionBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

public class CreateServiceAction
extends AbstractKubernetesAction {
    private final String serviceName;
    private final List<String> ports;
    private final List<String> targetPorts;
    private final String protocol;
    private final Map<String, String> podSelector;

    public CreateServiceAction(Builder builder) {
        super("create-service", builder);
        this.serviceName = builder.serviceName;
        this.ports = builder.ports;
        this.targetPorts = builder.targetPorts;
        this.protocol = builder.protocol;
        this.podSelector = builder.podSelector;
    }

    public void doExecute(TestContext context) {
        ArrayList<ServicePort> servicePorts = new ArrayList<ServicePort>();
        for (int i = 0; i < this.ports.size(); ++i) {
            String targetPort = i < this.targetPorts.size() ? this.targetPorts.get(i) : this.ports.get(i);
            servicePorts.add(((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("port-mapping-" + i)).withProtocol(context.replaceDynamicContentInString(this.protocol))).withPort(Integer.valueOf(Integer.parseInt(context.replaceDynamicContentInString(this.ports.get(i)))))).withTargetPort(new IntOrString((Object)Integer.parseInt(context.replaceDynamicContentInString(targetPort))))).build());
        }
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withNamespace(this.namespace(context))).withName(context.replaceDynamicContentInString(this.serviceName))).withLabels(KubernetesSettings.getDefaultLabels())).endMetadata()).withNewSpec().withSelector(context.resolveDynamicValuesInMap(this.podSelector))).withPorts(servicePorts)).endSpec()).build();
        Service created = (Service)((ServiceResource)((NonNamespaceOperation)this.getKubernetesClient().services().inNamespace(this.namespace(context))).resource((Object)service)).createOr(Updatable::update);
        if (created.getSpec().getClusterIP() != null) {
            context.setVariable(KubernetesVariableNames.SERVICE_CLUSTER_IP.value(), (Object)created.getSpec().getClusterIP());
        }
        if (this.isAutoRemoveResources()) {
            context.doFinally(KubernetesActionBuilder.kubernetes().client(this.getKubernetesClient()).services().delete(created.getMetadata().getName()).inNamespace(this.getNamespace()));
        }
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<CreateServiceAction, Builder>
    implements ReferenceResolverAware {
        private String serviceName = KubernetesSettings.getServiceName();
        private final List<String> ports = new ArrayList<String>();
        private final List<String> targetPorts = new ArrayList<String>();
        private String protocol = "TCP";
        private final Map<String, String> podSelector = new HashMap<String, String>();
        private HttpServer httpServer;
        private String httpServerName;
        private boolean autoCreateServerBinding = KubernetesSettings.isAutoCreateServerBinding();
        private ReferenceResolver referenceResolver;

        public Builder service(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder ports(String ... ports) {
            Arrays.stream(ports).forEach(this::port);
            return this;
        }

        public Builder ports(int ... ports) {
            Arrays.stream(ports).forEach(this::port);
            return this;
        }

        public Builder port(String port) {
            this.ports.add(port);
            return this;
        }

        public Builder port(int port) {
            this.ports.add(String.valueOf(port));
            return this;
        }

        public Builder portMapping(String port, String targetPort) {
            if (port != null) {
                this.port(port);
            }
            if (targetPort != null) {
                this.targetPort(targetPort);
            }
            return this;
        }

        public Builder portMapping(int port, int targetPort) {
            this.port(port);
            this.targetPort(targetPort);
            return this;
        }

        public Builder targetPorts(String ... targetPorts) {
            Arrays.stream(targetPorts).forEach(this::targetPort);
            return this;
        }

        public Builder targetPorts(int ... targetPorts) {
            Arrays.stream(targetPorts).forEach(this::targetPort);
            return this;
        }

        public Builder targetPort(String targetPort) {
            this.targetPorts.add(targetPort);
            return this;
        }

        public Builder targetPort(int targetPort) {
            this.targetPorts.add(String.valueOf(targetPort));
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder label(String label, String value) {
            this.podSelector.put(label, value);
            return this;
        }

        public Builder withPodSelector(Map<String, String> selector) {
            this.podSelector.putAll(selector);
            return this;
        }

        public Builder server(HttpServer httpServer) {
            this.httpServer = httpServer;
            return this;
        }

        public Builder server(String httpServerName) {
            this.httpServerName = httpServerName;
            return this;
        }

        public Builder autoCreateServerBinding(boolean enabled) {
            this.autoCreateServerBinding = enabled;
            return this;
        }

        @Override
        public Builder withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        @Override
        public CreateServiceAction doBuild() {
            if (this.podSelector.isEmpty()) {
                this.podSelector.put("citrusframework.org/test-id", "${%s}".formatted(CitrusSettings.TEST_NAME_VARIABLE));
            }
            String serverName = Optional.ofNullable(this.httpServerName).orElse(this.serviceName);
            if (this.httpServer == null) {
                if (this.referenceResolver != null && this.referenceResolver.isResolvable(serverName, HttpServer.class)) {
                    this.httpServer = (HttpServer)this.referenceResolver.resolve(serverName, HttpServer.class);
                } else if (this.autoCreateServerBinding) {
                    this.httpServer = (HttpServer)((HttpServerBuilder)((HttpServerBuilder)new HttpServerBuilder().autoStart(true)).port(KubernetesSettings.getServicePort())).name(serverName).build();
                    this.httpServer.initialize();
                }
            }
            if (this.ports.isEmpty()) {
                this.ports.add("80");
            }
            if (this.targetPorts.isEmpty()) {
                if (this.httpServer != null) {
                    this.targetPorts.add(String.valueOf(this.httpServer.getPort()));
                } else {
                    this.targetPorts.add(String.valueOf(KubernetesSettings.getServicePort()));
                }
            }
            if (this.referenceResolver != null && !this.referenceResolver.isResolvable(serverName, HttpServer.class)) {
                this.referenceResolver.bind(serverName, (Object)this.httpServer);
            }
            return new CreateServiceAction(this);
        }

        @Override
        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }
    }
}

