/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kubernetes.actions;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.Locale;
import org.citrusframework.context.TestContext;
import org.citrusframework.kubernetes.KubernetesSupport;
import org.citrusframework.kubernetes.actions.AbstractKubernetesAction;

public class DeleteCustomResourceAction
extends AbstractKubernetesAction {
    private final String resourceName;
    private final String type;
    private final Class<? extends HasMetadata> resourceType;
    private final String version;
    private final String kind;
    private final String group;

    public DeleteCustomResourceAction(Builder builder) {
        super("delete-custom-resource", builder);
        this.resourceName = builder.resourceName;
        this.type = builder.type;
        this.resourceType = builder.resourceType;
        this.group = builder.group;
        this.version = builder.version;
        this.kind = builder.kind;
    }

    public void doExecute(TestContext context) {
        String resolvedName = context.replaceDynamicContentInString(this.resourceName);
        if (this.resourceType != null) {
            ((Resource)((NonNamespaceOperation)this.getKubernetesClient().resources(this.resourceType).inNamespace(this.namespace(context))).withName(resolvedName)).delete();
        } else {
            ((Resource)((NonNamespaceOperation)this.getKubernetesClient().genericKubernetesResources(KubernetesSupport.crdContext(context.replaceDynamicContentInString(this.type), context.replaceDynamicContentInString(this.group), context.replaceDynamicContentInString(this.kind), context.replaceDynamicContentInString(this.version))).inNamespace(this.namespace(context))).withName(resolvedName)).delete();
        }
    }

    public static class Builder
    extends AbstractKubernetesAction.Builder<DeleteCustomResourceAction, Builder> {
        private String resourceName;
        private Class<? extends HasMetadata> resourceType;
        private String type;
        private String version;
        private String kind;
        private String group;

        public Builder resourceName(String name) {
            this.resourceName = name;
            return this;
        }

        public Builder resourceType(Class<? extends HasMetadata> resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder type(Class<? extends CustomResource<?, ?>> resourceType) {
            this.version(resourceType.getAnnotation(Version.class).value());
            this.group(resourceType.getAnnotation(Group.class).value());
            this.kind(resourceType.getSimpleName());
            this.type(String.format("%ss.%s/%s", this.kind.toLowerCase(Locale.ENGLISH), this.group, this.version));
            this.resourceType = resourceType;
            return this;
        }

        public Builder type(String resourceType) {
            this.type = resourceType;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            String[] groupAndVersion = apiVersion.split("/");
            this.group(groupAndVersion[0]);
            this.version(groupAndVersion[1]);
            return this;
        }

        @Override
        public DeleteCustomResourceAction doBuild() {
            return new DeleteCustomResourceAction(this);
        }
    }
}

